<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="light" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="disable">

<head>

    <meta charset="utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('site.judul') != null ? config('site.judul') : config('app.name')); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.png')); ?>">
    <?php echo $__env->yieldPushContent('plugin-style'); ?>
    <script src="<?php echo e(asset('build/js/layout.js')); ?>"></script>
    <link href="<?php echo e(asset('build/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('build/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('build/css/app.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('build/css/custom.min.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        .error-validation {
            font-size: .875em;
            margin-top: .25rem;
        }
    </style>
    <?php echo $__env->yieldPushContent('style'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


</head>

<body>
    <div id="layout-wrapper">
        <?php echo $__env->make('admin.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="vertical-overlay"></div>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
            <?php echo $__env->make('admin.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="<?php echo e(asset('build/libs/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('build/libs/simplebar/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('build/libs/node-waves/waves.min.js')); ?>"></script>
    <script src="<?php echo e(asset('build/libs/feather-icons/feather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('build/js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/sweetalert/sweetalert.all.js')); ?>"></script>
    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        // document.addEventListener('contextmenu', (e) => e.preventDefault());
        // function ctrlShiftKey(e, keyCode) {
        //     return e.ctrlKey && e.shiftKey && e.keyCode === keyCode.charCodeAt(0);
        // }
        // document.onkeydown = (e) => {
        //     if (
        //         event.keyCode === 123 ||
        //         ctrlShiftKey(e, 'I') ||
        //         ctrlShiftKey(e, 'J') ||
        //         ctrlShiftKey(e, 'C') ||
        //         (e.ctrlKey && e.keyCode === 'U'.charCodeAt(0))
        //     )
        //         return false;
        // };

        $('.table-responsive').on('show.bs.dropdown', function() {
            $('.table-responsive').css("overflow", "inherit");
        });

        $('.table-responsive').on('hide.bs.dropdown', function() {
            $('.table-responsive').css("overflow", "auto");
        })

        document.addEventListener('livewire:init', () => {
            Livewire.on('swal:modal', (event) => {
                Swal.fire({
                    title: event[0].message,
                    icon: event[0].type,
                    toast: event[0].toast,
                    position: event[0].position,
                    showConfirmButton: false,
                    timer: 2000
                });
            });

            Livewire.on('swal:confirm', (event) => {
                Swal.fire({
                        title: event[0].message,
                        icon: event[0].type,
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Hapus!',
                        cancelButtonText: 'Batal'
                    })
                    .then((result) => {
                        if (result.isConfirmed) {
                            Livewire.dispatch('destroy', {
                                id: event[0].id
                            });
                        }
                    });
            });
        });


        // window.addEventListener('swal:modal', event => {
        //     Swal.fire({
        //         title: event.detail.message,
        //         icon: event.detail.type,
        //         toast: event.detail.toast,
        //         position: event.detail.position,
        //         showConfirmButton: false,
        //         timer: 2000
        //     });
        //     console.log(event);
        // });

        // window.addEventListener('swal:confirm', event => {
        //     Swal.fire({
        //             title: event.detail.message,
        //             icon: event.detail.type,
        //             showCancelButton: true,
        //             confirmButtonColor: '#3085d6',
        //             cancelButtonColor: '#d33',
        //             confirmButtonText: 'Hapus!',
        //             cancelButtonText: 'Batal'
        //         })
        //         .then((result) => {
        //             if (result.isConfirmed) {
        //                 window.livewire.emit('destroy', event.detail.id);
        //             }
        //         });
        // });
    </script>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo $__env->yieldPushContent('script'); ?>
</body>

</html>
<?php /**PATH /Users/aptika/Workspace/webprofilev2/resources/views/admin/layouts/app.blade.php ENDPATH**/ ?>