<?php if($data->isNotEmpty()): ?>
    <div>
        <div class="mt-0">
            <h4 class="mb-2 ls-1 text-uppercase fw-bold">Instagram Feeds</h4>
            <div class="line line-xs line-sports"></div>
            <div class="row grid-container gutter-30">
                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-lg-4 col-sm-6">
                        <div class="card instagram-feed">
                            <div class="card-body p-0">
                                <div class="entry mb-0">
                                    <div class="entry-image mb-0">
                                        <?php if($res->media_type == 'IMAGE'): ?>
                                            <a href="javascript:void(0)"
                                               onclick="detail_post('<?php echo e($res->media_id); ?>')"><img
                                                     src="<?php echo e($res->media_url); ?>" alt="" class="img-fluid"></a>
                                        <?php elseif($res->media_type == 'CAROUSEL_ALBUM'): ?>
                                            <div class="fslider" data-arrows="false" data-speed="400" data-pause="4000">
                                                <div class="flexslider">
                                                    <div class="slider-wrap">
                                                        <?php $__currentLoopData = $res->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="slide">
                                                                <a href="javascript:void(0)"
                                                                   onclick="detail_post('<?php echo e($res->media_id); ?>')"><img
                                                                         src="<?php echo e($rc['media_url']); ?>" alt=""
                                                                         class="img-fluid"></a>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <a href="javascript:void(0)"
                                               onclick="detail_post('<?php echo e($res->media_id); ?>')"><img
                                                     src="<?php echo e($res->thumbnail_url); ?>" alt=""
                                                     class="img-fluid"></a>
                                        <?php endif; ?>
                                        <div class="entry-categories">
                                            <a class="bg-travel"><?php echo e($res->media_type); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer p-2 mb-0">
                                <span style="font-size: 10pt"><a class="text-primary" href="<?php echo e($res->permalink); ?>"
                                       target="_blank"><?php echo e($res->to_profile->username); ?></a> -
                                    <?php echo e($res->timestamp); ?></span>
                                <p class="mb-0" style="font-size: 9pt"><?php echo e(Str::words($res->caption, 10, '...')); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <span>Belum Ada Post</span>
                <?php endif; ?>
            </div>
            <div class="row mt-4">
                <?php if($data->isNotEmpty()): ?>
                    <?php echo e($data->links()); ?>

                <?php endif; ?>
            </div>
        </div>

        <div class="modal" id="modal-instagram" tabindex="-1" role="dialog" aria-labelledby="modal-instagram"
             aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modal-label">Detail Posting</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="loader"></div>
                            <div class="col-lg-7 mb-4" id="md-ig-content">

                            </div>
                            <div class="col-lg-5">
                                <span class="fw-bold" id="md-ig-username"></span>
                                <p class="mt-3 text-justify" id="md-ig-caption" style="font-size: 10pt"></p>
                                <span class="text-muted" style="font-size: 9pt;" id="md-ig-timestamp"></span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer p-2">
                        <button type="button" class="btn btn-primary" onclick="close_modal()">Tutup</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('style'); ?>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"
              integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g=="
              crossorigin="anonymous" referrerpolicy="no-referrer" />
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('script'); ?>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"
                integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw=="
                crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="<?php echo e(asset('guest/js/instagram.js')); ?>" type="text/javascript"></script>
    <?php $__env->stopPush(); ?>

<?php endif; ?>
<?php /**PATH /Users/aptika/Workspace/webprofile-instagram/resources/views/components/guest/instagram.blade.php ENDPATH**/ ?>