<div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row g-2">
                        <div class="col-sm-4">
                            <div class="search-box">
                                <input type="text" class="form-control" wire:model.live="key" placeholder="Cari Nama">
                                <i class="ri-search-line search-icon"></i>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-sm-auto ms-auto">
                            <div class="list-grid-nav hstack gap-1">
                                <div wire:loading.remove wire:target="open_modal">
                                    <button class="btn btn-success" type="button" wire:click="open_modal"><i
                                            class="ri-add-fill me-1 align-bottom"></i> Tambah</button>
                                </div>
                                <div wire:loading wire:target="open_modal">
                                    <button class="btn btn-success" type="button" disabled="">Loading..</button>
                                </div>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-nowrap table-striped-columns mb-0 text-center">
                            <thead class="table-light">
                                <tr>
                                    <th width="1%" scope="col">#</th>
                                    <th width="15%" scope="col">Email</th>
                                    <th width="25%" scope="col">Nama</th>
                                    <th width="10%">Roles</th>
                                    <th width="5%">Status</th>
                                    <th width="1%" scope="col">#</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(($data->currentpage() - 1) * $data->perpage() + $i + 1); ?>.</td>
                                        <td><?php echo e($res->email); ?></td>
                                        <td><?php echo e($res->name); ?></td>

                                        <td>
                                            <!--[if BLOCK]><![endif]--><?php if($res->roles == 1): ?>
                                                Administrator
                                            <?php else: ?>
                                                Editor
                                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center">
                                                <label class="form-check form-switch form-switch-md ms-3"
                                                    for="setStatus_<?php echo e($res->id); ?>">
                                                    <input type="checkbox" class="form-check-input"
                                                        id="setStatus_<?php echo e($res->id); ?>" onclick="set_status(this)"
                                                        value="<?php echo e($res->id); ?>" data-to-status="<?php echo e($res->is_active == 0 ? 1:0); ?>"
                                                        <?php echo e($res->is_active ? 'checked' : ''); ?>>
                                                </label>
                                            </div>
                                        </td>
                                        <td>
                                            <div wire:key="dsub_<?php echo e($res->id); ?>">
                                                <div class="btn-group">
                                                    <button class="btn btn-primary btn-sm dropdown-toggle"
                                                        type="button" data-bs-toggle="dropdown" aria-haspopup="true"
                                                        aria-expanded="false">
                                                        Aksi
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="edit(<?php echo e($res->id); ?>)">Edit</a>
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="edit_password(<?php echo e($res->id); ?>)">Ganti
                                                            Password</a>
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="confirm(<?php echo e($res->id); ?>)">Hapus</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6"><strong>No Data</strong></td>
                                    </tr>
                                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                        <!--[if BLOCK]><![endif]--><?php if($data->isNotEmpty()): ?>
                            <div class="py-2">
                                <?php echo e($data->links()); ?>

                            </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" tabindex="-1" id="modal-tambah">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form wire:submit.prevent="store">
                    <div class="modal-header">
                        <h3 class="modal-title">Tambah</h3>
                    </div>

                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">
                                        Nama <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control" name="name" id="name"
                                        wire:model.defer="name">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">
                                        Email <span class="text-danger">*</span>
                                    </label>
                                    <input type="email" class="form-control" name="email" id="email"
                                        wire:model.defer="email">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">
                                        Roles <span class="text-danger">*</span>
                                    </label>
                                    <div wire:ignore>
                                        <select name="roles" id="roles" wire:model.defer="roles"
                                            class="form-control">
                                            <option value="">Pilih ...</option>
                                            <option value="1">Administrator</option>
                                            <option value="2">Editor</option>
                                        </select>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['roles'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">
                                        Password <span class="text-danger">*</span>
                                    </label>
                                    <input type="password" class="form-control" name="password" id="password"
                                        wire:model.defer="password">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">
                                        Konfirmasi Password <span class="text-danger">*</span>
                                    </label>
                                    <input type="password" class="form-control" name="password_confirmation"
                                        id="password_confirmation" wire:model.defer="password_confirmation">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">
                                        Status <span class="text-danger">*</span>
                                    </label>
                                    <div wire:ignore>
                                        <select name="status" id="statusF" wire:model.defer="status"
                                            class="form-control">
                                            <option value="">Pilih ...</option>
                                            <option value="1">Aktif</option>
                                            <option value="0">Tidak Aktif</option>
                                        </select>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tutup</button>
                        <div wire:loading.remove wire:target="store">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                        <div wire:loading wire:target="store">
                            <button class="btn btn-primary" type="button" disabled>
                                <span class="spinner-border spinner-border-sm" role="status"
                                    aria-hidden="true"></span>
                                Loading...
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" tabindex="-1" id="modal-password">
        <div class="modal-dialog">
            <div class="modal-content">
                <form wire:submit.prevent="update_password">
                    <div class="modal-header">
                        <h3 class="modal-title">Ganti Password</h3>
                    </div>

                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">
                                Password <span class="text-danger">*</span>
                            </label>
                            <input type="password" class="form-control" name="cgpassword" id="cgpassword"
                                wire:model.defer="cgpassword">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['cgpassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="mb-3">
                            <label class="form-label">
                                Konfirmasi Password <span class="text-danger">*</span>
                            </label>
                            <input type="password" class="form-control" name="cgpassword_confirmation"
                                id="cgpassword_confirmation" wire:model.defer="cgpassword_confirmation">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['cgpassword_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tutup</button>
                        <div wire:loading.remove wire:target="update_password">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                        <div wire:loading wire:target="update_password">
                            <button class="btn btn-primary" type="button" disabled>
                                <span class="spinner-border spinner-border-sm" role="status"
                                    aria-hidden="true"></span>
                                Loading...
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" tabindex="-1" id="modal-edit">
        <div class="modal-dialog">
            <div class="modal-content">
                <form wire:submit.prevent="update">
                    <div class="modal-header">
                        <h3 class="modal-title">Edit</h3>
                    </div>

                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">
                                Nama <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control" name="nameEd" id="nameEd"
                                wire:model.defer="nameEd">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['nameEd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="mb-3">
                            <label class="form-label">
                                Email <span class="text-danger">*</span>
                            </label>
                            <input type="email" class="form-control" name="emailEd" id="emailEd"
                                wire:model.defer="emailEd" readonly>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['emailEd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="mb-3">
                            <label class="form-label">
                                Roles <span class="text-danger">*</span>
                            </label>
                            <div wire:ignore>
                                <select name="rolesEd" id="rolesEd" wire:model.defer="rolesEd"
                                    class="form-control">
                                    <option value="">Pilih ...</option>
                                    <option value="1">Administrator</option>
                                    <option value="2">Editor</option>
                                </select>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['rolesEd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="mb-3">
                            <label class="form-label">
                                Status <span class="text-danger">*</span>
                            </label>
                            <select name="statusEd" id="statusEd" wire:model.defer="statusEd" class="form-control">
                                <option value="">Pilih ...</option>
                                <option value="1">Aktif</option>
                                <option value="0">Tidak Aktif</option>
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['statusEd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tutup</button>
                        <div wire:loading.remove wire:target="update">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                        <div wire:loading wire:target="update">
                            <button class="btn btn-primary" type="button" disabled>
                                <span class="spinner-border spinner-border-sm" role="status"
                                    aria-hidden="true"></span>
                                Loading...
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('plugin-style'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(window).on('load', function() {
            init_create();
            init_edit();
        });

        $('#roles').on('change', function(e) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('roles', e.target.value);
        });
        $('#rolesEd').on('change', function(e) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('rolesEd', e.target.value);
        });
        $('#statusF').on('change', function(e) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('status', e.target.value);
        });
        $('#statusEd').on('change', function(e) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('statusEd', e.target.value);
        });

        document.addEventListener('livewire:init', () => {
            Livewire.on('show-modal', (event) => {
                $('#modal-tambah').modal('show');
            });

            Livewire.on('close-modal', event => {
                $('#modal-tambah').modal('hide');
            });

            Livewire.on('show-modal-password', event => {
                $('#modal-password').modal('show');
            });

            Livewire.on('close-modal-password', event => {
                $('#modal-password').modal('hide');
            });

            Livewire.on('show-modal-edit', event => {
                init_edit()
                $('#modal-edit').modal('show');
            });

            Livewire.on('close-modal-edit', event => {
                $('#modal-edit').modal('hide');
            });
        });

        Livewire.hook('commit', ({
            component,
            commit,
            respond,
            succeed,
            fail
        }) => {
            succeed(({
                snapshot,
                effect
            }) => {
                queueMicrotask(() => {
                    init_create();
                    init_edit();
                })
            })

            fail(() => {

            })
        })


        function init_create() {
            $('#statusF, #roles').select2({
                placeholder: "Pilih ...",
                dropdownParent: $('#modal-tambah')
            });
        }

        function init_edit() {
            $('#statusEd, #rolesEd').select2({
                placeholder: "Pilih ...",
                dropdownParent: $('#modal-edit')
            });
        }

        function set_status(el)
        {
            Livewire.dispatch('set-status', {id: el.value, status:el.getAttribute('data-to-status')});
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /Users/aptika/Workspace/webprofilev2/resources/views/livewire/pengaturan/user.blade.php ENDPATH**/ ?>