<div>
    <div class="row">
        <div class="col-lg-5">
            <div class="card">
                <form wire:submit.prevent="<?php echo e($aksi); ?>">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Buat Menu Parent</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="parentNama" class="form-label">Nama Menu <span
                                    class="text-danger">*</span></label>
                            <input type="text" name="parentNama" id="parentNama" class="form-control"
                                wire:model="parentNama">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['parentNama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="mb-3">
                            <label for="jenisLink" class="form-label">Jenis Link <span
                                    class="text-danger">*</span></label>
                            <div wire:ignore>
                                <select name="jenisLink" id="jenisLink" class="form-control" wire:model="jenisLink">
                                    <option value=""></option>
                                    <option value="internal">Internal</option>
                                    <option value="eksternal">Eksternal</option>
                                </select>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['jenisLink'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($jenisLink): ?>
                            <!--[if BLOCK]><![endif]--><?php if($jenisLink == 'internal'): ?>
                                <div class="mb-0">
                                    <label for="parentTarget" class="form-label">Target Halaman <span
                                            class="text-danger">*</span></label>
                                    <div wire:ignore>
                                        <select name="parentTarget" id="parentTarget" class="form-control"
                                            wire:model="parentTarget">
                                            <option value=""></option>
                                            <option value="#"># - Root</option>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $dataLink; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($link->route); ?>"><?php echo e($link->judul); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                        </select>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['parentTarget'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php else: ?>
                                <div class="mb-0">
                                    <label for="parentTarget" class="form-label">Target Halaman <span
                                            class="text-danger">*</span></label>
                                    <input type="text" name="parentTargetInput" id="parentTargetInput"
                                        class="form-control" wire:model="parentTarget">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['parentTarget'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="card-footer">
                        <div class="d-flex">
                            <div wire:loading.remove wire:target="reset_fields">
                                <button type="button" wire:click="reset_fields"
                                    class="btn btn-danger me-2">Reset</button>
                            </div>
                            <div wire:loading wire:target="reset_fields">
                                <button class="btn btn-danger me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                            <div wire:loading.remove wire:target="<?php echo e($aksi); ?>">
                                <button type="submit" class="btn btn-success me-2">Simpan</button>
                            </div>
                            <div wire:loading wire:target="<?php echo e($aksi); ?>">
                                <button class="btn btn-success me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-7">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Atur Menu</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group rounded-0">
                        <li class="list-group-item">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <div class="d-flex">
                                        <a href="javascript:void(0)" class="fw-medium text-primary">Beranda</a>
                                    </div>
                                </div>

                            </div>
                        </li>
                        <!--[if BLOCK]><![endif]--><?php if($data->isNotEmpty()): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item rounded-0">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <div class="d-flex">
                                                <a href="<?php echo e($res->target); ?>" target="_blank"
                                                    class="fw-medium text-primary"><?php echo e($res->nama); ?></a>
                                            </div>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div wire:key="dparent_<?php echo e($res->id); ?>">
                                                <div class="btn-group me-4">
                                                    <button class="btn btn-primary btn-sm dropdown-toggle"
                                                        type="button" data-bs-toggle="dropdown" aria-haspopup="true"
                                                        aria-expanded="false">
                                                        Aksi
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="create_child(<?php echo e($res->id); ?>)">Tambah Sub
                                                            Menu</a>
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="edit(<?php echo e($res->id); ?>)">Edit</a>
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="confirm(<?php echo e($res->id); ?>)">Hapus</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <!--[if BLOCK]><![endif]--><?php if($res->to_child->isNotEmpty()): ?>
                                    <ul class="list-group ms-5 my-2 rounded-0">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $res->to_child; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="list-group-item">
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-grow-1">
                                                        <div class="d-flex">
                                                            <a href="<?php echo e($rc->target); ?>"
                                                                target="_blank"
                                                                class="fw-medium text-primary"><?php echo e($rc->nama); ?></a>
                                                        </div>
                                                    </div>
                                                    <div class="flex-shrink-0">
                                                        <div wire:key="dchild_<?php echo e($rc->id); ?>">
                                                            <div class="btn-group">
                                                                <button class="btn btn-warning btn-sm dropdown-toggle"
                                                                    type="button" data-bs-toggle="dropdown"
                                                                    aria-haspopup="true" aria-expanded="false">
                                                                    Aksi
                                                                </button>
                                                                <div class="dropdown-menu">
                                                                    <a class="dropdown-item" href="javascript:void(0)"
                                                                        wire:click="edit_child(<?php echo e($rc->id); ?>)">Edit</a>
                                                                    <a class="dropdown-item" href="javascript:void(0)"
                                                                        wire:click="confirm_child(<?php echo e($rc->id); ?>)">Hapus</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                    </ul>
                                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade zoomIn" id="modal-tambah" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0">
                <form wire:submit.prevent="<?php echo e($aksiChild); ?>">
                    <div class="modal-header p-3 bg-soft-info">
                        <h5 class="modal-title">Sub Menu</h5>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="childNama" class="form-label">
                                Nama Sub Menu <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control" name="childNama" id="childNama"
                                wire:model="childNama">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['childNama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="mb-3">
                            <label for="jenisLinkChild" class="form-label">Jenis Link <span
                                    class="text-danger">*</span></label>
                            <div wire:ignore>
                                <select name="jenisLinkChild" id="jenisLinkChild" class="form-control"
                                    wire:model="jenisLinkChild">
                                    <option value=""></option>
                                    <option value="internal">Internal</option>
                                    <option value="eksternal">Eksternal</option>
                                </select>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['jenisLinkChild'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger error-validation">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($jenisLinkChild): ?>
                            <!--[if BLOCK]><![endif]--><?php if($jenisLinkChild == 'internal'): ?>
                                <div class="mb-0">
                                    <label for="childTarget" class="form-label">Target Halaman <span
                                            class="text-danger">*</span></label>
                                    <div wire:ignore>
                                        <select name="childTarget" id="childTarget" wire:model="childTarget"
                                            class="form-control">
                                            <option value="">Pilih ...</option>
                                            <option value="#"># - Root</option>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $dataLink; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linkc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($linkc->route); ?>"><?php echo e($linkc->judul); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                        </select>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['childTarget'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php else: ?>
                                <div class="mb-0">
                                    <label for="childTarget" class="form-label">Target Halaman <span
                                            class="text-danger">*</span></label>
                                    <input type="text" name="childTargetInput" id="childTargetInput"
                                        class="form-control" wire:model="childTarget">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['childTarget'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger error-validation">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tutup</button>
                        <div wire:loading.remove wire:target="<?php echo e($aksiChild); ?>">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                        <div wire:loading wire:target="<?php echo e($aksiChild); ?>">
                            <button class="btn btn-primary" type="button" disabled>
                                <span class="spinner-border spinner-border-sm" role="status"
                                    aria-hidden="true"></span>
                                Loading...
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('plugin-style'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(window).on('load', function() {
            init_create();
            init_child();
        });

        document.addEventListener('livewire:init', () => {
            Livewire.on('show-modal', (event) => {
                $('#modal-tambah').modal('show');
            });

            Livewire.on('close-modal', event => {
                $('#modal-tambah').modal('hide');
            });

            Livewire.on('swal:confirm-child', (event) => {
                Swal.fire({
                        title: event[0].message,
                        icon: event[0].type,
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Hapus!',
                        cancelButtonText: 'Batal'
                    })
                    .then((result) => {
                        if (result.isConfirmed) {
                            Livewire.dispatch('destroy-child', {
                                id: event[0].id
                            });
                        }
                    });
            });

            Livewire.on('edit-parent', (event) => {
                init_create();
            });

            Livewire.on('edit-child', (event) => {
                init_child();
            })

        });

        Livewire.hook('commit', ({
            component,
            commit,
            respond,
            succeed,
            fail
        }) => {
            succeed(({
                snapshot,
                effect
            }) => {
                queueMicrotask(() => {
                    init_create();
                    init_child();
                })
            })

            fail(() => {

            })
        })


        function init_create() {
            $('#parentTarget').select2({
                placeholder: "Pilih ...",
            }).on('select2:select', function(e) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('parentTarget', e.target.value);
            });

            $('#jenisLink').select2({
                placeholder: "Pilih ...",
            }).on('select2:select', function(e) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('jenisLink', e.target.value);
            });
        }

        function init_child() {
            $('#childTarget').select2({
                placeholder: "Pilih ...",
                dropdownParent: $('#modal-tambah')
            }).on('select2:select', function(e) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('childTarget', e.target.value);
            });

            $('#jenisLinkChild').select2({
                placeholder: "Pilih ...",
            }).on('select2:select', function(e) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('jenisLinkChild', e.target.value);
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /Users/aptika/Workspace/webprofilev2/resources/views/livewire/menu.blade.php ENDPATH**/ ?>