<?php

use App\Http\Controllers\AlbumKegiatan;
use App\Http\Controllers\HalamanController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PengaturanController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\PengumumanController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\UnduhanController;
use App\Http\Controllers\GuestController;
use App\Http\Controllers\LinkController;
use App\Http\Controllers\InstagramController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [GuestController::class, 'beranda'])->name('beranda');

Route::get('/login', [AuthController::class, 'index'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post')->middleware('throttle:login');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/auth/instagram/callback', [InstagramController::class, 'handle'])->name('instagram');

Route::middleware(['auth'])->group(function () {
    Route::get('/admin/dashboard', [DashboardController::class, 'index'])->name('dashboard')->middleware(['roles:1,2']);
    Route::group(['prefix' => '/admin/pengaturan/', 'as' => 'pengaturan.', 'middleware' => ['roles:1']], function () {
        Route::get('/informasi-website', [PengaturanController::class, 'informasi_website'])->name('informasi-website');
        Route::get('/pengguna', [PengaturanController::class, 'pengguna'])->name('pengguna');
        Route::get('/media-sosial', [PengaturanController::class, 'media_sosial'])->name('media-sosial');
        Route::get('/slider', [PengaturanController::class, 'slider'])->name('slider');
        Route::get('/instagram', [InstagramController::class, 'index'])->name('instagram');
        Route::get('/instagram-auth-response-success', [InstagramController::class, 'response_success'])->name('instagram-response-success');
        Route::get('/instagram-auth-response-error', [InstagramController::class, 'response_error'])->name('instagram-response-error');
    });

    Route::group(['prefix' => '/admin/halaman/', 'as' => 'halaman.', 'middleware' => ['roles:1,2']], function () {
        Route::get('/semua-halaman', [HalamanController::class, 'index'])->name('semua-halaman');
        Route::get('/buat-baru', [HalamanController::class, 'create'])->name('buat-baru');
        Route::post('/buat-baru', [HalamanController::class, 'store'])->name('store-halaman');

        Route::get('/halaman/{id}/edit', [HalamanController::class, 'edit'])->name('edit-halaman');
        Route::put('/halaman/{id}/update', [HalamanController::class, 'update'])->name('update-halaman');
        Route::delete('/halaman/{id}/delete', [HalamanController::class, 'destroy'])->name('destroy-halaman');

        Route::get('/sampah', [HalamanController::class, 'sampah'])->name('sampah');
        Route::put('/halaman/{id}/restore', [HalamanController::class, 'restore'])->name('restore-halaman');
        Route::delete('/halaman/{id}/force-delete', [HalamanController::class, 'force_delete'])->name('force-delete-halaman');
    });

    Route::group(['prefix' => '/admin/post/', 'as' => 'post.', 'middleware' => ['roles:1,2']], function () {
        Route::get('/semua-post', [PostController::class, 'index'])->name('semua-post');
        Route::get('/buat-baru', [PostController::class, 'create'])->name('buat-baru');
        Route::post('/buat-baru', [PostController::class, 'store'])->name('store-post');
        Route::get('/kategori', [PostController::class, 'kategori'])->name('kategori');

        Route::get('/post/{id}/edit', [PostController::class, 'edit'])->name('edit-post');
        Route::put('/post/{id}/update', [PostController::class, 'update'])->name('update-post');
        Route::delete('/post/{id}/delete', [PostController::class, 'destroy'])->name('destroy-post');

        Route::get('/sampah', [PostController::class, 'sampah'])->name('sampah');
        Route::put('/post/{id}/restore', [PostController::class, 'restore'])->name('restore-post');
        Route::delete('/post/{id}/force-delete', [PostController::class, 'force_delete'])->name('force-delete-post');
    });

    Route::group(['prefix' => '/admin/pengumuman/', 'as' => 'pengumuman.', 'middleware' => ['roles:1,2']], function () {
        Route::get('/semua-pengumuman', [PengumumanController::class, 'index'])->name('semua-pengumuman');
        Route::get('/buat-baru', [PengumumanController::class, 'create'])->name('buat-baru');
        Route::post('/buat-baru', [PengumumanController::class, 'store'])->name('store-pengumuman');

        Route::get('/pengumuman/{id}/edit', [PengumumanController::class, 'edit'])->name('edit-pengumuman');
        Route::put('/pengumuman/{id}/update', [PengumumanController::class, 'update'])->name('update-pengumuman');
        Route::delete('/pengumuman/{id}/delete', [PengumumanController::class, 'destroy'])->name('destroy-pengumuman');

        Route::get('/sampah', [PengumumanController::class, 'sampah'])->name('sampah');
        Route::put('/pengumuman/{id}/restore', [PengumumanController::class, 'restore'])->name('restore-pengumuman');
        Route::delete('/pengumuman/{id}/force-delete', [PengumumanController::class, 'force_delete'])->name('force-delete-pengumuman');
    });

    Route::get('/admin/menu', [MenuController::class, 'index'])->name('admin.menu')->middleware(['roles:1,2']);
    Route::get('/admin/unduhan', UnduhanController::class)->name('admin.unduhan')->middleware(['roles:1,2']);
    Route::get('/admin/album-kegiatan', [AlbumKegiatan::class, 'album_kegiatan'])->name('admin.album-kegiatan')->middleware(['roles:1,2']);
    Route::get('/admin/foto-kegiatan/{id}', [AlbumKegiatan::class, 'foto_kegiatan'])->name('admin.foto-kegiatan')->middleware(['roles:1,2']);
    Route::get('/admin/link', LinkController::class)->name('admin.link')->middleware(['roles:1,2']);
});


Route::get('/halaman/{slug}', [GuestController::class, 'halaman'])->name('halaman');
Route::get('/post/{slug}', [GuestController::class, 'post'])->name('post');
Route::get('/kategori/{slug?}', [GuestController::class, 'kategori'])->name('kategori');
Route::get('/pengumuman/{slug?}', [GuestController::class, 'pengumuman'])->name('pengumuman');
Route::get('/unduhan', [GuestController::class, 'unduhan'])->name('unduhan');
Route::get('/unduh/{folder}/{file}', [GuestController::class, 'unduh'])->name('unduh');
Route::get('/album-kegiatan/{slug?}', [GuestController::class, 'album_kegiatan'])->name('album-kegiatan');
Route::get('/album-kegiatan/{slug}/foto', [GuestController::class, 'foto_kegiatan'])->name('foto-kegiatan');
Route::get('/cari', [GuestController::class, 'cari'])->name('cari')->middleware('decodeurls');
Route::get('/get-detail-post', [InstagramController::class, 'get_detail_post'])->name('get-detail-post');


Route::get('/sitemap.xml', [GuestController::class, 'sitemap'])->name('sitemap');
Route::get('/sitemap/post.xml', [GuestController::class, 'sitemap_post'])->name('sitemap-post');
Route::get('/sitemap/menu.xml', [GuestController::class, 'sitemap_menu'])->name('sitemap-menu');
Route::get('/sitemap/kategori.xml',[GuestController::class, 'sitemap_kategori'])->name('sitemap-kategori');
Route::get('/sitemap/pengumuman.xml',[GuestController::class, 'sitemap_pengumuman'])->name('sitemap-pengumuman');


Route::group(['prefix' => 'laravel-filemanager', 'middleware' => ['web', 'auth']], function () {
    \UniSharp\LaravelFilemanager\Lfm::routes();
});
