<div>
    <div class="row">
        <div class="col-lg-4">
            <form wire:submit.prevent="{{ $aksi }}">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="judul" class="form-label">Judul <span class="text-danger">*</span></label>
                            <input type="text" name="judul" id="judul" wire:model="judul" class="form-control">
                            @error('judul')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mb-0">
                            <div x-data="{ uploading: false, progress: 0 }" x-on:livewire-upload-start="uploading = true"
                                x-on:livewire-upload-finish="uploading = false"
                                x-on:livewire-upload-cancel="uploading = false"
                                x-on:livewire-upload-error="uploading = false"
                                x-on:livewire-upload-progress="progress = $event.detail.progress">
                                <label for="file_{{ $iter }}" class="form-label">File <span
                                        class="text-danger">*</span></label>
                                <input type="file" name="file" id="file_{{ $iter }}" wire:model="file"
                                    class="form-control">
                                <div x-show="uploading">
                                    <progress max="100" x-bind:value="progress" style="width:100%"></progress>
                                </div>
                            </div>
                            @error('file')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mt-2 mb-0">
                            <p class="text-muted mb-0">
                                File yang diupload berukuran maksimal <code>12 Mb</code>
                            </p>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="d-flex">
                            <div wire:loading.remove wire:target="reset_fields">
                                <button type="button" wire:click="reset_fields"
                                    class="btn btn-danger me-2">Reset</button>
                            </div>
                            <div wire:loading wire:target="reset_fields">
                                <button class="btn btn-danger me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                            <div wire:loading.remove wire:target="{{ $aksi }}">
                                <button type="submit" class="btn btn-success me-2">Simpan</button>
                            </div>
                            <div wire:loading wire:target="{{ $aksi }}">
                                <button class="btn btn-success me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped-columns mb-0 text-center">
                            <thead class="table-light">
                                <tr>
                                    <th width="1%">No.</th>
                                    <th class="min-w-250px">Judul</th>
                                    <th width="5%">Status</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($data as $i => $res)
                                    <tr>
                                        <td>{{ $i + 1 }}.</td>
                                        <td>{{ $res->judul }}</td>
                                        <td>
                                            <div class="d-flex justify-content-center">
                                                <label class="form-check form-switch form-switch-md ms-3"
                                                    for="setStatus_{{ $res->id }}">
                                                    <input type="checkbox" class="form-check-input"
                                                        id="setStatus_{{ $res->id }}" onclick="set_status(this)"
                                                        value="{{ $res->id }}"
                                                        data-to-status="{{ $res->is_active == 0 ? 1 : 0 }}"
                                                        {{ $res->is_active ? 'checked' : '' }}>
                                                </label>
                                            </div>
                                        </td>
                                        <td>
                                            <div wire:key="kategori-post_{{ $res->id }}">
                                                <div class="btn-group">
                                                    <button class="btn btn-primary btn-sm dropdown-toggle"
                                                        type="button" data-bs-toggle="dropdown" aria-haspopup="true"
                                                        aria-expanded="false">
                                                        Aksi
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="edit({{ $res->id }})">Edit</a>
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="confirm({{ $res->id }})">Hapus</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3"><strong>No Data</strong></td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@push('script')
    <script>
        function set_status(el) {
            Livewire.dispatch('set-status', {
                id: el.value,
                status: el.getAttribute('data-to-status')
            });
        }
    </script>
@endpush
