<div>
    <div class="row">
        <div class="col-lg-5">
            <form wire:submit.prevent="{{ $aksi }}">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="platform" class="form-label">Platform <span class="text-danger">*</span></label>
                            <div wire:ignore>
                                <select name="platform" id="platform" class="form-control" wire:model="platform">
                                    <option value=""></option>
                                    <option value="facebook">Facebook</option>
                                    <option value="instagram">Instagram</option>
                                    <option value="youtube">Youtube</option>
                                    <option value="x">X (Twitter)</option>
                                    <option value="threads">Threads</option>
                                    <option value="email">Email</option>
                                    <option value="whatsapp">Whatsapp</option>
                                </select>
                            </div>
                            @error('platform')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mb-0">
                            <label for="url" class="form-label">Full Link <span class="text-danger">*</span></label>
                            <input type="text" name="url" id="url" wire:model="url" class="form-control">
                            @error('url')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="d-flex">
                            <div wire:loading.remove wire:target="reset_fields">
                                <button type="button" wire:click="reset_fields"
                                    class="btn btn-danger me-2">Reset</button>
                            </div>
                            <div wire:loading wire:target="reset_fields">
                                <button class="btn btn-danger me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                            <div wire:loading.remove wire:target="{{ $aksi }}">
                                <button type="submit" class="btn btn-success me-2">Simpan</button>
                            </div>
                            <div wire:loading wire:target="{{ $aksi }}">
                                <button class="btn btn-success me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-lg-7">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Media Sosial</h5>
                </div>
                <div class="card-body">
                    <div class="live-preview">
                        @if ($data->isNotEmpty())
                            <ul class="list-group mb-1">
                                @foreach ($data as $res)
                                    <li class="list-group-item">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <div class="d-flex">
                                                    <div class="flex-shrink-0 avatar-xs">
                                                        <div class="avatar-title bg-soft-primary rounded">
                                                            <img src="{{ asset('socials/'.$res->platform.'.svg') }}" alt="" width="20">
                                                        </div>
                                                    </div>
                                                    <div class="flex-shrink align-self-center ms-2">
                                                        <a href="{{ $res->url }}" target="_blank" class="link-primary link-offset-2 text-decoration-underline link-underline-opacity-25 link-underline-opacity-100-hover text-capitalize fw-bold">{{ $res->platform }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <div wire:key="dsub_{{ $res->id }}">
                                                    <div class="btn-group">
                                                        <button class="btn btn-primary btn-sm dropdown-toggle"
                                                            type="button" data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                            Aksi
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="javascript:void(0)"
                                                                wire:click="edit({{ $res->id }})">Edit</a>
                                                            <a class="dropdown-item" href="javascript:void(0)"
                                                                wire:click="confirm({{ $res->id }})">Hapus</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        @else
                            <h6 class="text-center mb-0 fw-bold">No Data</h6>
                        @endif
                    </div>
                </div><!-- end card-body -->
            </div>
        </div>
    </div>
</div>
@push('plugin-style')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush
@push('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(window).on('load', function() {
            init();
        });

        $('#platform').on('change', function(e) {
            @this.set('platform', e.target.value);
        });

        Livewire.hook('commit', ({
            component,
            commit,
            respond,
            succeed,
            fail
        }) => {
            succeed(({
                snapshot,
                effect
            }) => {
                queueMicrotask(() => {
                    init();
                })
            })

            fail(() => {

            })
        })


        function init() {
            $('#platform').select2({
                placeholder: "Pilih ..."
            });
        }
    </script>
@endpush
