<div>
    <div class="row">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <form wire:submit.prevent="{{ $aksi }}">
                        <div class="mb-3">
                            <label for="nama" class="form-label">Nama <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="nama" wire:model="nama" class="form-control">
                            @error('nama')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="d-flex">
                            <div wire:loading.remove wire:target="reset_fields">
                                <button type="button" wire:click="reset_fields"
                                        class="btn btn-danger me-2">Reset</button>
                            </div>
                            <div wire:loading wire:target="reset_fields">
                                <button class="btn btn-danger me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                            <div wire:loading.remove wire:target="{{ $aksi }}">
                                <button type="submit" class="btn btn-success me-2">Simpan</button>
                            </div>
                            <div wire:loading wire:target="{{ $aksi }}">
                                <button class="btn btn-success me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped-columns mb-0 text-center">
                            <thead class="table-light">
                                <tr>
                                    <th width="1%">No.</th>
                                    <th class="min-w-250px">Nama</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($data as $i => $res)
                                    <tr>
                                        <td>{{ $i + 1 }}.</td>
                                        <td>{{ $res->username }}</td>
                                        <td>
                                            <div wire:key="kategori-post_{{ $res->id }}">
                                                <div class="d-flex gap-2">
                                                    <div class="btn-group">
                                                        <button class="btn btn-primary btn-sm dropdown-toggle"
                                                                type="button" data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            Aksi
                                                        </button>
                                                        <div class="dropdown-menu">

                                                            @if (!$res->to_access_token)
                                                                <a class="dropdown-item"
                                                                   href="{{ env('INSTAGRAM_AUTH_URL') }}&state={{ $res->id }}">Autentikasi</a>
                                                            @else
                                                                <a class="dropdown-item" href="javascript:void(0)"
                                                                   wire:click="refresh_feeds({{ $res->id }})">Refresh
                                                                    Feed</a>
                                                                <a class="dropdown-item" href="javascript:void(0)"
                                                                   wire:click="refresh_token({{ $res->id }})">Refresh
                                                                    Token</a>
                                                            @endif
                                                            <a class="dropdown-item" href="javascript:void(0)"
                                                               wire:click="confirm({{ $res->id }})">Hapus</a>

                                                        </div>
                                                    </div>
                                                    <div wire:loading wire:target="refresh_feeds({{ $res->id }})">
                                                        <button class="btn btn-icon btn-sm btn-success me-2"
                                                                type="button" disabled="">
                                                            <span class="spinner-border spinner-border-sm"
                                                                  role="status" aria-hidden="true"></span>
                                                            <span class="visually-hidden">Loading...</span>
                                                        </button>
                                                    </div>
                                                    <div wire:loading wire:target="refresh_token({{ $res->id }})">
                                                        <button class="btn btn-icon btn-sm btn-success me-2"
                                                                type="button" disabled="">
                                                            <span class="spinner-border spinner-border-sm"
                                                                  role="status" aria-hidden="true"></span>
                                                            <span class="visually-hidden">Loading...</span>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3"><strong>No Data</strong></td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
