<div>
    @if ($data->isNotEmpty())
        <div class="mt-0 mb-4">
            <h4 class="mb-2 ls-1 text-uppercase fw-bold">Berita Terbaru</h4>
            <div class="line line-xs line-sports"></div>
            <div class="row col-mb-50 mb-0" id="scroll-dest">
                @forelse ($data as $res)
                    <div class="entry col-md-12 mb-0">
                        <div class="row">
                            <div class="col-md-5">
                                <div class="entry-image mb-0">
                                    <a href="{{ route('post', ['slug' => $res->slug]) }}">
                                        <img src="{{ $res->thumbnail ? asset('storage/' . $res->thumbnail) : asset('default.jpg') }}"
                                             onerror="this.src='{{ asset('default.jpg') }}'"
                                             style="width:415px;height:250px;object-fit:cover;object-position: 100% 0%;"
                                             alt="Image">
                                    </a>
                                    <div class="entry-categories">
                                        <a href="{{ route('kategori', ['slug' => $res->to_kategori->slug]) }}"
                                           class="bg-tech">{{ $res->to_kategori->nama }}</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="entry-title title-sm mt-3 mt-md-0">
                                    <h3 class="mb-2">
                                        <a href="{{ route('post', ['slug' => $res->slug]) }}">{{ $res->judul }}</a>
                                    </h3>
                                </div>
                                <div class="entry-meta">
                                    <ul>
                                        <li>
                                            <i class="bi-clock"></i>
                                            {{ tanggal_indo($res->tanggal_publish) }}
                                        </li>
                                        <li>
                                            <i class="uil uil-user"></i> {{ $res->to_user->name }}
                                        </li>
                                    </ul>
                                </div>
                                <div class="entry-content mt-3">
                                    {!! strip_tags(Str::words($res->konten, 40, '...')) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <span>Belum Ada Artikel</span>
                @endforelse
                @if ($data->isNotEmpty())
                    {{ $data->links() }}
                @endif
            </div>
        </div>
        @push('script')
            <script>
                document.addEventListener('livewire:init', () => {
                    Livewire.on('scroll-top', (event) => {
                        document.querySelector('#scroll-dest').scrollIntoView({
                            behavior: 'smooth'
                        });
                    });
                });
            </script>
        @endpush
    @endif
</div>
