<div>
    <div class="row">
        <div class="col-lg-4">
            <form wire:submit.prevent="store">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-0">
                            <label for="file" class="form-label">Upload File <span class="text-danger">*</span></label>
                            <input type="file" multiple name="file" id="file_{{ $iter }}" wire:model="file"
                                class="form-control">
                            @error('file.*')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mt-2 mb-0">
                            <p class="text-muted mb-0">
                                Gambar yang diupload berukuran <code>1280x760 pixel</code> atau aspect ratio <code>16:9</code>
                            </p>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="d-flex">
                            <a href="{{ route('admin.album-kegiatan') }}" class="btn btn-primary btn-label waves-effect waves-light me-2">
                                <div class="d-flex">
                                    <div class="flex-shrink-0">
                                        <i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        Kembali
                                    </div>
                                </div>
                            </a>
                            <div wire:loading.remove wire:target="reset_fields">
                                <button type="button" wire:click="reset_fields"
                                    class="btn btn-danger me-2">Reset</button>
                            </div>
                            <div wire:loading wire:target="reset_fields">
                                <button class="btn btn-danger me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                            <div wire:loading.remove wire:target="store">
                                <button type="submit" class="btn btn-success me-2">Simpan</button>
                            </div>
                            <div wire:loading wire:target="store">
                                <button class="btn btn-success me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-lg-8">
            <div class="row">
                @forelse ($data as $res)
                    <div class="col-xxl-6 col-xl-4 col-sm-6">
                        <div class="card">
                            <div class="card-body p-2">
                                <figure class="figure mb-0">
                                    <img src="{{ Storage::url($res->file) }}" class="figure-img img-fluid rounded mb-0">
                                </figure>
                            </div>
                            <div class="card-footer py-2">
                                <div class="flex-shrink-0">
                                    <div wire:key="slider_{{ $res->id }}">
                                        <div class="d-flex align-items-center">
                                            <div wire:loading.remove wire:target="confirm({{ $res->id }})">
                                                <button type="button" wire:click="confirm({{ $res->id }})"
                                                    class="btn btn-icon btn-sm btn-danger me-2"><i
                                                        class="ri-delete-bin-line"></i></button>
                                            </div>
                                            <div wire:loading wire:target="confirm({{ $res->id }})">
                                                <button class="btn btn-icon btn-sm btn-danger me-2" type="button"
                                                    disabled="">
                                                    <span class="spinner-border spinner-border-sm" role="status"
                                                        aria-hidden="true"></span>
                                                    <span class="visually-hidden">Loading...</span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12">
                        <div class="alert alert-danger shadow mb-xl-0" role="alert">
                            <strong> No Data! </strong>
                        </div>
                    </div>
                @endforelse
            </div>

        </div>
    </div>
</div>
