<div>
    <div class="row">
        <div class="col-lg-4">
            <form wire:submit.prevent="{{ $aksi }}">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="judul" class="form-label">Judul Album <span class="text-danger">*</span></label>
                            <input type="text" name="judul" id="judul" wire:model="judul" class="form-control">
                            @error('judul')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="tanggalPublish" class="form-label">Tanggal Kegiatan <span
                                    class="text-danger">*</span></label>
                            <input type="text" name="tanggalPublish" id="tanggalPublish" wire:model="tanggalPublish"
                                class="form-control">
                            @error('tanggalPublish')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label" for="statusPublish">Status <span
                                    class="text-danger">*</span></label>
                            <div wire:ignore>
                                <select class="form-control" id="statusPublish" name="statusPublish"
                                    wire:model="statusPublish">
                                    <option value=""></option>
                                    <option value="1">Aktif</option>
                                    <option value="0">Tidak Aktif</option>
                                </select>
                            </div>
                            @error('statusPublish')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mb-0">
                            <label for="deskripsi" class="form-label">Deskripsi</label>
                            <textarea name="deskripsi" id="deskripsi" rows="6" class="form-control" wire:model="deskripsi"
                                style="resize: none"></textarea>
                            @error('deskripsi')
                                <div class="text-danger error-validation">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="d-flex">
                            <div wire:loading.remove wire:target="reset_fields">
                                <button type="button" wire:click="reset_fields"
                                    class="btn btn-danger me-2">Reset</button>
                            </div>
                            <div wire:loading wire:target="reset_fields">
                                <button class="btn btn-danger me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                            <div wire:loading.remove wire:target="{{ $aksi }}">
                                <button type="submit" class="btn btn-success me-2">Simpan</button>
                            </div>
                            <div wire:loading wire:target="{{ $aksi }}">
                                <button class="btn btn-success me-2" type="button" disabled="">Loading..
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-lg-8">
            <div class="card mb-2">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped-columns mb-0 text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th width="50%">Judul</th>
                                    <th>Deskripsi</th>
                                    <th width="5%">#</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($data as $i => $res)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <a href="{{ route('admin.foto-kegiatan', ['id' => $res->id]) }}"
                                                        class="text-white">
                                                        <div class="avatar-xs">
                                                            <div class="avatar-title rounded">
                                                                <i class="ri-folder-2-fill align-bottom fs-17"></i>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h5 class="mb-1 fs-6">{{ $res->judul }}</h5>
                                                    <p class="mb-0 fs-12 text-muted">
                                                        {{ tanggal_indo($res->tanggal_publish) }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $res->deskripsi ?? '-' }}</td>
                                        <td>
                                            <div wire:key="album-kegiatan_{{ $res->id }}">
                                                <div class="btn-group">
                                                    <button class="btn btn-primary btn-sm dropdown-toggle"
                                                        type="button" data-bs-toggle="dropdown" aria-haspopup="true"
                                                        aria-expanded="false">
                                                        Aksi
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item"
                                                            href="{{ route('admin.foto-kegiatan', ['id' => $res->id]) }}"
                                                            wire:click="edit({{ $res->id }})">Tambah Foto</a>
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="edit({{ $res->id }})">Edit</a>
                                                        <a class="dropdown-item" href="javascript:void(0)"
                                                            wire:click="confirm({{ $res->id }})">Hapus</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3"><strong>No Data</strong></td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @if ($data->isNotEmpty())
                <div class="py-2">
                    {{ $data->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@push('plugin-style')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush
@push('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('build/libs/flatpickr/flatpickr.min.js') }}"></script>
    <script src="https://npmcdn.com/flatpickr@4.6.13/dist/l10n/id.js"></script>
    <script>
        $(window).on('load', function() {
            init_create();
        });

        Livewire.hook('commit', ({
            component,
            commit,
            respond,
            succeed,
            fail
        }) => {
            succeed(({
                snapshot,
                effect
            }) => {
                queueMicrotask(() => {
                    init_create();
                })
            })

            fail(() => {

            })
        })


        function init_create() {
            $('#tanggalPublish').flatpickr({
                locale: "id",
                disableMobile: "true",
                onChange: function(date, datestr) {
                    @this.set('tanggalPublish', datestr);
                }
            });

            $('#statusPublish').select2({
                placeholder: "Pilih .."
            }).on('select2:select', function(e) {
                @this.set("statusPublish", e.target.value);
            });
        }
    </script>
@endpush
