@extends('guest.layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-9">
            <div class="col-12">
                <div class="style-msg primarymsg mb-3">
                    <div class="sb-msg"><i class="bi-question-circle-sign"></i>Dalam <strong>Unduhan</strong></div>
                </div>
            </div>
            <div class="mt-0">
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered text-center align-middle">
                            <thead>
                                <tr>
                                    <th width="3%">No.</th>
                                    <th>Judul</th>
                                    <th width="10%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($data as $i => $res)
                                    <tr>
                                        <td>{{ ($data->currentpage() - 1) * $data->perpage() + $i + 1 }}.</td>
                                        <td class="text-start">
                                            {{ $res->judul }}
                                            <div class="fst-italic text-primary" style="font-size: 9pt">Diupload pada
                                                {{ tanggal_indo($res->created_at) }}</div>
                                        </td>
                                        <td>
                                            <a href="{{ url('unduh/' . $res->file) }}"><span
                                                      class="badge bg-primary p-2">Download</span></a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3"><strong>Belum Ada Data</strong></td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    @if ($data->isNotEmpty())
                        <div class="py-4">
                            {{ $data->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-3 sticky-sidebar-wrap mt-0 mt-lg-0">
            <div class="sticky-sidebar">
                <x-guest.skm></x-guest.skm>
                <x-guest.sosial-media></x-guest.sosial-media>
                <x-guest.kategori></x-guest.kategori>
                <x-guest.link></x-guest.link>
            </div>
        </div>
    </div>
@endsection
