@extends('guest.layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-9">
            <div class="col-12">
                <div class="style-msg primarymsg mb-3">
                    <div class="sb-msg"><i class="bi-question-circle-sign"></i>Dalam <strong>Semua Kategori</strong></div>
                </div>
            </div>
            <div class="mt-0">
                <div class="col-12">
                    @if ($data->isNotEmpty())
                        <ul class="list-group">
                            @foreach ($data as $res)
                                <li class="list-group-item">
                                    <a href="{{ route('kategori', ['slug' => $res->slug]) }}" class="text-black"> {{ $res->nama }}</a>
                                    <span class="badge bg-danger float-end">{{ $res->to_post_count }}</span>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <span>Belum Ada Data</span>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-3 sticky-sidebar-wrap mt-0 mt-lg-0">
            <div class="sticky-sidebar">
                <x-guest.skm></x-guest.skm>
                <x-guest.sosial-media></x-guest.sosial-media>
                <x-guest.kategori></x-guest.kategori>
                <x-guest.link></x-guest.link>
            </div>
        </div>
    </div>
@endsection
