@extends('guest.layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-9">
            <div class="col-12">
                <div class="style-msg primarymsg">
                    <div class="sb-msg"><i class="bi-question-circle-sign"></i>Hasil Pencarian <strong>
                            {{ $key }}</strong></div>
                </div>
            </div>
            <div class="mt-0">
                <div class="row col-mb-50 mb-0">
                    @forelse ($data as $res)
                        <div class="col-md-6">
                            <div class="posts-md">
                                <div class="entry">
                                    <div class="entry-image">
                                        <a href="{{ route('post', ['slug' => $res->slug]) }}"><img
                                                 src="{{ $res->thumbnail ? asset('storage/'.$res->thumbnail) : asset('default.jpg') }}"
                                                 onerror="this.onerror=null;this.src='{{ asset('default.jpg') }}'"
                                                 style="width:415px;height:250px;object-fit:cover;object-position: 100% 0%;" alt="Image 3"></a>
                                        <div class="entry-categories"><a
                                               href="{{ route('kategori', ['slug' => $res->to_kategori->slug]) }}"
                                               class="bg-tech">{{ $res->to_kategori->slug }}</a>
                                        </div>
                                    </div>
                                    <div class="entry-title title-sm text-transform-none">
                                        <h3 class="mb-2"><a
                                               href="{{ route('post', ['slug' => $res->slug]) }}">{{ $res->judul }}</a>
                                        </h3>
                                    </div>
                                    <div class="entry-meta">
                                        <ul>
                                            <li><i class="bi-clock"></i>{{ tanggal_indo($res->tanggal_publish) }}</li>
                                            <li><i class="uil uil-user"></i>{{ $res->to_user->name }}</li>
                                        </ul>
                                    </div>
                                    <div class="entry-content">
                                        {!! strip_tags(Str::words($res->konten, 40, '...')) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <span>Hasil Tidak Ditemukan</span>
                    @endforelse
                    @if ($data->isNotEmpty())
                        {{ $data->links() }}
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-3 sticky-sidebar-wrap mt-0 mt-lg-0">
            <div class="sticky-sidebar">
                <x-guest.skm></x-guest.skm>
                <x-guest.sosial-media></x-guest.sosial-media>
                <x-guest.kategori></x-guest.kategori>
                <x-guest.link></x-guest.link>
            </div>
        </div>
    </div>
@endsection
