<!DOCTYPE html>
<html dir="ltr" lang="en-US">

    <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Roboto+Slab:wght@400;600;700&family=Roboto:wght@400;500;700&display=swap"
              rel="stylesheet">
        <link rel="stylesheet" href="{{ asset('guest/style.css') }}">
        <link rel="stylesheet" href="{{ asset('guest/css/font-icons.css') }}">
        <link rel="stylesheet" href="{{ asset('guest/news.css') }}">
        <link rel="stylesheet" href="{{ asset('guest/photographer.css') }}">
        <link rel="stylesheet" href="{{ asset('guest/css/custom.css') }}">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="shortcut icon" href="{{ asset('favicon.png') }}">
        <title>{{ config('site.judul') != null ? config('site.judul') : config('app.name') }}</title>
        <style>
            .hesperiden .tp-tab {
                border-bottom: 0;
            }

            .hesperiden .tp-tab:hover,
            .hesperiden .tp-tab.selected {
                background-color: #E5E5E5;
            }

            iframe {
                border: none;
                /* height: 80vh; */
                width: 100%;
            }

            .entry-content ul,
            ol {
                padding-left: 3.5rem;
            }
        </style>
        @stack('style')
        @livewireStyles
    </head>

    <body class="stretched">
        <div id="wrapper">
            <header id="header" class="header-size-sm" data-sticky-shrink="false">
                @include('guest.layouts.header')
            </header>
            <section id="content">
                <div class="content-wrap">
                    <x-guest.slider-pengumuman></x-guest.slider-pengumuman>
                    <div class="container">
                        @yield('content')
                    </div>
                </div>
            </section>
            <footer id="footer" class="dark" style="background-color: #1f2024;">
                @include('guest.layouts.footer')
            </footer>
        </div>
        <div id="gotoTop" class="uil uil-angle-up"></div>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
                integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
                crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="{{ asset('guest/js/functions.js') }}"></script>
        <script>
            jQuery('.nav.tab-hover a.nav-link').hover(function() {
                jQuery(this).tab('show');
            });
            var weekday = ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
                month = ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober",
                    "November", "Desember"
                ],
                a = new Date();
            jQuery('.date-today').html(weekday[a.getDay()] + ', ' + a.getDate() + ' ' + month[a.getMonth()] + ' ' + a
                .getFullYear());
        </script>
        @livewireScripts
        @stack('script')
    </body>

</html>
