@extends('guest.layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-9">
            <div class="mt-0">
                <div class="entry">
                    <h2 class="mb-3 fw-bold h1">{{ $data->judul }}</h2>
                    <div class="entry-meta d-flex justify-content-between mb-4">
                        <ul>
                            <li><i class="uil uil-user"></i> {{ $data->to_user->name }}</li>
                        </ul>
                    </div>
                    <div class="card border-0 border-top rounded-0 border-default mt-4 mb-5">
                        <div class="card-body pt-3 px-0">
                            <div class="d-flex align-items-center justify-content-between">
                                <h6 class="fs-6 fw-semibold mb-0">Bagikan:</h6>
                                <div class="d-flex">
                                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}"
                                       target="_blank"
                                       class="social-icon text-white border-transparent rounded-circle bg-facebook"
                                       title="Facebook" style="--cnvs-socialicon-size:2rem;">
                                        <i><img src="{{ asset('socials/guest/facebook.svg') }}" width="15"
                                                 height="15" alt="Image" style="margin-bottom: 3px"></i>
                                        <i><img src="{{ asset('socials/guest/facebook.svg') }}" width="15"
                                                 height="15" alt="Image" style="margin-bottom: 3px"></i>
                                    </a>

                                    <a href="https://twitter.com/intent/tweet?text={{ $data->judul . '%0A%0A' . url()->current() }}"
                                       target="_blank"
                                       class="social-icon text-white border-transparent rounded-circle bg-dark"
                                       title="Twitter" style="--cnvs-socialicon-size:2rem;">
                                        <i><img src="{{ asset('socials/guest/x.svg') }}" width="15" height="15"
                                                 alt="Image" style="margin-bottom: 3px"></i>
                                        <i><img src="{{ asset('socials/guest/x.svg') }}" width="15" height="15"
                                                 alt="Image" style="margin-bottom: 3px"></i>
                                    </a>

                                    <a href="https://threads.net/intent/post?text={{ $data->judul . '%0A%0A' . url()->current() }}"
                                       target="_blank"
                                       class="social-icon text-white border-transparent rounded-circle bg-dark"
                                       title="Threads" style="--cnvs-socialicon-size:2rem;">
                                        <i><img src="{{ asset('socials/guest/threads.svg') }}" width="15" height="15"
                                                 alt="Image" style="margin-bottom: 3px"></i>
                                        <i><img src="{{ asset('socials/guest/threads.svg') }}" width="15"
                                                 height="15" alt="Image" style="margin-bottom: 3px"></i>
                                    </a>

                                    <a href="https://api.whatsapp.com/send?text={{ $data->judul . '%0A%0A' . url()->current() }}"
                                       target="_blank"
                                       class="social-icon text-white border-transparent rounded-circle bg-whatsapp"
                                       title="Whatsapp" style="--cnvs-socialicon-size:2rem;">
                                        <i><img src="{{ asset('socials/guest/whatsapp.svg') }}" width="15"
                                                 height="15" alt="Image" style="margin-bottom: 3px"></i>
                                        <i><img src="{{ asset('socials/guest/whatsapp.svg') }}" width="15"
                                                 height="15" alt="Image" style="margin-bottom: 3px"></i>
                                    </a>

                                </div>
                            </div>
                        </div>
                    </div>

                    @if ($data->thumbnail)
                        <div class="entry-image">
                            <a href="{{ route('halaman', ['slug' => $data->slug]) }}"><img
                                     src="{{ $data->thumbnail ? asset('storage/'.$data->thumbnail) : asset('default.jpg') }}"
                                     onerror="this.src='{{ asset('default.jpg') }}'" alt="Image 3"></a>
                        </div>
                    @endif

                    <div class="entry-content mt-0">
                        {!! $data->konten !!}
                    </div>

                </div>
            </div>
        </div>
        <div class="col-lg-3 sticky-sidebar-wrap mt-0 mt-lg-0">
            <div class="sticky-sidebar">
                <x-guest.skm></x-guest.skm>
                <x-guest.sosial-media></x-guest.sosial-media>
                <x-guest.kategori></x-guest.kategori>
                <x-guest.link></x-guest.link>
            </div>
        </div>
    </div>
@endsection
