@if ($data->isNotEmpty())
    <div>
        <div class="mt-0">
            <h4 class="mb-2 ls-1 text-uppercase fw-bold">Instagram Feeds</h4>
            <div class="line line-xs line-sports"></div>
            <div class="row grid-container gutter-30">
                @forelse ($data as $res)
                    <div class="col-lg-4 col-sm-6">
                        <div class="card instagram-feed">
                            <div class="card-body p-0">
                                <div class="entry mb-0">
                                    <div class="entry-image mb-0">
                                        @if ($res->media_type == 'IMAGE')
                                            <a href="javascript:void(0)"
                                               onclick="detail_post('{{ $res->media_id }}')"><img
                                                     src="{{ $res->media_url }}" alt="" class="img-fluid"></a>
                                        @elseif($res->media_type == 'CAROUSEL_ALBUM')
                                            <div class="fslider" data-arrows="false" data-speed="400" data-pause="4000">
                                                <div class="flexslider">
                                                    <div class="slider-wrap">
                                                        @foreach ($res->children as $rc)
                                                            <div class="slide">
                                                                <a href="javascript:void(0)"
                                                                   onclick="detail_post('{{ $res->media_id }}')"><img
                                                                         src="{{ $rc['media_url'] }}" alt=""
                                                                         class="img-fluid"></a>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                            <a href="javascript:void(0)"
                                               onclick="detail_post('{{ $res->media_id }}')"><img
                                                     src="{{ $res->thumbnail_url }}" alt=""
                                                     class="img-fluid"></a>
                                        @endif
                                        <div class="entry-categories">
                                            <a class="bg-travel">{{ $res->media_type }}</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer p-2 mb-0">
                                <span style="font-size: 10pt"><a class="text-primary" href="{{ $res->permalink }}"
                                       target="_blank">{{ $res->to_profile->username }}</a> -
                                    {{ $res->timestamp }}</span>
                                <p class="mb-0" style="font-size: 9pt">{{ Str::words($res->caption, 10, '...') }}</p>
                            </div>
                        </div>
                    </div>
                @empty
                    <span>Belum Ada Post</span>
                @endforelse
            </div>
            <div class="row mt-4">
                @if ($data->isNotEmpty())
                    {{ $data->links() }}
                @endif
            </div>
        </div>

        <div class="modal" id="modal-instagram" tabindex="-1" role="dialog" aria-labelledby="modal-instagram"
             aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modal-label">Detail Posting</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="loader"></div>
                            <div class="col-lg-7 mb-4" id="md-ig-content">

                            </div>
                            <div class="col-lg-5">
                                <span class="fw-bold" id="md-ig-username"></span>
                                <p class="mt-3 text-justify" id="md-ig-caption" style="font-size: 10pt"></p>
                                <span class="text-muted" style="font-size: 9pt;" id="md-ig-timestamp"></span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer p-2">
                        <button type="button" class="btn btn-primary" onclick="close_modal()">Tutup</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @push('style')
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"
              integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g=="
              crossorigin="anonymous" referrerpolicy="no-referrer" />
    @endpush
    @push('script')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"
                integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw=="
                crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="{{ asset('guest/js/instagram.js') }}" type="text/javascript"></script>
    @endpush

@endif
