@if ($data->isNotEmpty())
    <div class="widget">
        <h4 class="mb-2 ls-1 text-uppercase fw-bold">Berita Lainnya</h4>
        <div class="line line-xs line-home"></div>
        <div class="posts-sm row col-mb-30">
            @foreach ($data as $res)
                <div class="entry col-12">
                    <div class="grid-inner row align-items-center g-0">
                        <div class="col-auto">
                            <div class="entry-image">
                                <a href="{{ route('post', ['slug' => $res->slug]) }}">
                                    <img src="{{ $res->thumbnail ? asset('storage/'.$res->thumbnail) : asset('default.jpg') }}"
                                         onerror="this.src='{{ asset('default.jpg') }}'" alt="Image">
                                </a>
                            </div>
                        </div>
                        <div class="col ps-3">
                            <div class="entry-title">
                                <h4 class="fw-semibold">
                                    <a href="{{ route('post', ['slug' => $res->slug]) }}">{{ Str::words($res->judul, 7, '...') }}</a>
                                </h4>
                            </div>
                            <div class="entry-meta">
                                <ul>
                                    <li>
                                        <i class="bi-clock"></i>
                                        {{ tanggal_indo($res->tanggal_publish) }}
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endif
