@extends('admin.layouts.auth')
@section('content')
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-5">
            <div class="card mt-4">

                <div class="card-body p-4">
                    <div class="text-center mt-2">
                        <h5 class="text-primary">Selamat Datang !</h5>
                        <p class="text-muted">Masukan Username dan Password.</p>
                    </div>
                    <div class="p-2 mt-4">
                        <form action="{{ route('login.post') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="email" class="form-label">Username <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('email') is-invalid @enderror"
                                    id="email" name="email" autocomplete="off" value="{{ old('email') ?? '' }}">
                                @error('email')
                                    <div class="text-danger error-validation">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="password">Password <span class="text-danger">*</span></label>
                                <input type="password" class="form-control " name="password" id="password" autocomplete="off">
                                @error('password')
                                    <div class="text-danger error-validation">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="1" id="remember"
                                    name="remember">
                                <label class="form-check-label" for="remember">Ingat saya</label>
                            </div>

                            <div class="mt-4">
                                <button type="submit" class="btn btn-success w-100 mb-2">Login</button>
                                <a href="{{ url('/') }}" class="btn btn-warning w-100">Kembali</a>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- end card body -->
            </div>
            <!-- end card -->

        </div>
    </div>
@endsection
