@extends('admin.layouts.app')
@section('content')
    <x-breadcrumb :title="$bc['title']" :subtitle="$bc['subtitle']" />
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-auto">
                            <div class="hstack gap-2">
                                <a href="{{ route('post.buat-baru') }}" class="btn btn-primary"><i
                                        class="ri-add-line align-bottom me-1"></i> Buat Post</a>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-auto ms-sm-auto align-self-center">
                            <a href="{{ route('post.sampah') }}"
                                class="link-danger link-offset-2 text-decoration-underline link-underline-opacity-25 link-underline-opacity-100-hover">Sampah
                                ({{ $sampah }})</a>
                        </div>
                        <!--end col-->
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-nowrap table-striped-columns mb-0 text-center">
                            <thead class="table-light">
                                <tr>
                                    <th width="1%" scope="col">No.</th>
                                    <th scope="col">Judul</th>
                                    <th width="15%" scope="col">Dibuat Oleh</th>
                                    <th width="5%">Tanggal Publish</th>
                                    <th width="5%">Status</th>
                                    <th width="1%" scope="col">#</th>
                                </tr>
                            </thead>
                            <tbody class="align-middle">
                                @forelse ($data as $i => $res)
                                    <tr>
                                        <td>{{ ($data->currentpage() - 1) * $data->perpage() + $i + 1 }}.</td>
                                        <td class="text-start">{{ $res->judul }}</td>
                                        <td>{{ $res->to_user->name }}</td>
                                        <td>{{ \Carbon\Carbon::parse($res->tanggal_publish)->isoFormat('DD MMMM YYYY') }}
                                        </td>
                                        <td>
                                            @if ($res->is_active == 1)
                                                <span class="badge badge-label bg-success">Aktif</span>
                                            @else
                                                <span class="badge badge-label bg-danger">Tidak Aktif</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button class="btn btn-primary btn-sm dropdown-toggle" type="button"
                                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    Aksi
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item"
                                                        href="{{ route('post.edit-post', ['id' => $res->id]) }}">Edit</a>
                                                    <form method="POST"
                                                        action="{{ route('post.destroy-post', ['id' => $res->id]) }}">
                                                        @csrf
                                                        @method('delete')
                                                        <a class="dropdown-item confirm">Hapus</a>
                                                    </form>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center"><strong>No Data</strong></td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        @if ($data->isNotEmpty())
                            <div class="p-2">
                                {{ $data->links() }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script>
        $('.confirm').click(function(event) {
            var form = $(this).closest("form");
            event.preventDefault();
            Swal.fire({
                    title: "Hapus Data?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Hapus!',
                    cancelButtonText: 'Batal'
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
        });
    </script>
@endpush
