<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="light" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="disable">

<head>

    <meta charset="utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('site.judul') != null ? config('site.judul') : config('app.name') }}</title>
    <link rel="shortcut icon" href="{{ asset('favicon.png') }}">
    @stack('plugin-style')
    <script src="{{ asset('build/js/layout.js') }}"></script>
    <link href="{{ asset('build/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('build/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('build/css/app.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('build/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
    <style>
        .error-validation {
            font-size: .875em;
            margin-top: .25rem;
        }
    </style>
    @stack('style')
    @livewireStyles

</head>

<body>
    <div id="layout-wrapper">
        @include('admin.layouts.header')
        @include('admin.layouts.sidebar')
        <div class="vertical-overlay"></div>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    @yield('content')
                </div>
            </div>
            @include('admin.layouts.footer')
        </div>
    </div>
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="{{ asset('build/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('build/libs/simplebar/simplebar.min.js') }}"></script>
    <script src="{{ asset('build/libs/node-waves/waves.min.js') }}"></script>
    <script src="{{ asset('build/libs/feather-icons/feather.min.js') }}"></script>
    <script src="{{ asset('build/js/app.js') }}"></script>
    <script src="{{ asset('vendor/sweetalert/sweetalert.all.js') }}"></script>
    @include('sweetalert::alert')
    <script>
        // document.addEventListener('contextmenu', (e) => e.preventDefault());
        // function ctrlShiftKey(e, keyCode) {
        //     return e.ctrlKey && e.shiftKey && e.keyCode === keyCode.charCodeAt(0);
        // }
        // document.onkeydown = (e) => {
        //     if (
        //         event.keyCode === 123 ||
        //         ctrlShiftKey(e, 'I') ||
        //         ctrlShiftKey(e, 'J') ||
        //         ctrlShiftKey(e, 'C') ||
        //         (e.ctrlKey && e.keyCode === 'U'.charCodeAt(0))
        //     )
        //         return false;
        // };

        $('.table-responsive').on('show.bs.dropdown', function() {
            $('.table-responsive').css("overflow", "inherit");
        });

        $('.table-responsive').on('hide.bs.dropdown', function() {
            $('.table-responsive').css("overflow", "auto");
        })

        document.addEventListener('livewire:init', () => {
            Livewire.on('swal:modal', (event) => {
                Swal.fire({
                    title: event[0].message,
                    icon: event[0].type,
                    toast: event[0].toast,
                    position: event[0].position,
                    showConfirmButton: false,
                    timer: 2000
                });
            });

            Livewire.on('swal:confirm', (event) => {
                Swal.fire({
                        title: event[0].message,
                        icon: event[0].type,
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Hapus!',
                        cancelButtonText: 'Batal'
                    })
                    .then((result) => {
                        if (result.isConfirmed) {
                            Livewire.dispatch('destroy', {
                                id: event[0].id
                            });
                        }
                    });
            });
        });


        // window.addEventListener('swal:modal', event => {
        //     Swal.fire({
        //         title: event.detail.message,
        //         icon: event.detail.type,
        //         toast: event.detail.toast,
        //         position: event.detail.position,
        //         showConfirmButton: false,
        //         timer: 2000
        //     });
        //     console.log(event);
        // });

        // window.addEventListener('swal:confirm', event => {
        //     Swal.fire({
        //             title: event.detail.message,
        //             icon: event.detail.type,
        //             showCancelButton: true,
        //             confirmButtonColor: '#3085d6',
        //             cancelButtonColor: '#d33',
        //             confirmButtonText: 'Hapus!',
        //             cancelButtonText: 'Batal'
        //         })
        //         .then((result) => {
        //             if (result.isConfirmed) {
        //                 window.livewire.emit('destroy', event.detail.id);
        //             }
        //         });
        // });
    </script>
    @livewireScripts
    @stack('script')
</body>

</html>
