@extends('admin.layouts.app')
@section('content')
    <x-breadcrumb :title="$bc['title']" :subtitle="$bc['subtitle']" />
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-nowrap table-striped-columns mb-0 text-center">
                            <thead class="table-light">
                                <tr>
                                    <th width="1%" scope="col">No.</th>
                                    <th scope="col">Judul</th>
                                    <th width="15%" scope="col">Dibuat Oleh</th>
                                    <th width="5%">Tanggal Hapus</th>
                                    <th width="1%" scope="col">#</th>
                                </tr>
                            </thead>
                            <tbody class="align-middle">
                                @forelse ($data as $i => $res)
                                    <tr>
                                        <td>{{ ($data->currentpage() - 1) * $data->perpage() + $i + 1 }}.</td>
                                        <td class="text-start">{{ $res->judul }}</td>
                                        <td>{{ $res->to_user->name }}</td>
                                        <td>{{ \Carbon\Carbon::parse($res->deleted_at)->isoFormat('DD MMMM YYYY') }}
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button class="btn btn-primary btn-sm dropdown-toggle" type="button"
                                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    Aksi
                                                </button>
                                                <div class="dropdown-menu">
                                                    <form method="POST"
                                                        action="{{ route('halaman.restore-halaman', ['id' => $res->id]) }}">
                                                        @csrf
                                                        @method('put')
                                                        <a class="dropdown-item" onclick="event.preventDefault(); this.closest('form').submit();">Restore</a>
                                                    </form>

                                                    <form method="POST"
                                                        action="{{ route('halaman.force-delete-halaman', ['id' => $res->id]) }}">
                                                        @csrf
                                                        @method('delete')
                                                        <a class="dropdown-item confirm">Hapus Permanen</a>
                                                    </form>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center"><strong>No Data</strong></td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        @if ($data->isNotEmpty())
                            <div class="py-2">
                                {{ $data->links() }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script>
        $(window).on('load', function() {
            $('.confirm').click(function(event) {
                var form = $(this).closest("form");
                event.preventDefault();
                Swal.fire({
                        title: "Hapus Data?",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Hapus!',
                        cancelButtonText: 'Batal'
                    })
                    .then((result) => {
                        if (result.isConfirmed) {
                            form.submit();
                        }
                    });
            });
        });
    </script>
@endpush
