@extends('admin.layouts.app')
@section('content')
    <x-breadcrumb :title="$bc['title']" :subtitle="$bc['subtitle']" />
    {{-- <div class="row"> --}}
    <form action="{{ route('halaman.update-halaman', ['id' => $data->id]) }}" method="post" enctype="multipart/form-data"
        class="row">
        @csrf
        @method('put')
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label" for="judul">Judul <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="judul" name="judul"
                            value="{{ $data->judul ?? old('judul') }}">
                        @error('judul')
                            <div class="text-danger error-validation">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="konten">Konten <span class="text-danger">*</span></label>
                        <div id="toolbar-container"></div>
                        <textarea name="konten" id="konten" rows="4" class="form-control">{{ $data->konten ?? old('konten') }}</textarea>
                        @error('konten')
                            <div class="text-danger error-validation">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <div class="mb-0">
                        <label class="form-label" for="thumbnail">Thumbnail</label>
                        <input type="file" name="thumbnail" id="thumbnail" class="form-control">
                        @if ($data->thumbnail)
                            <div class="live-preview mt-3">
                                <div class="row align-items-center">
                                    <div class="col-12">
                                        <img class="rounded" width="200" src="{{ asset('storage/'.$data->thumbnail) }}">
                                    </div>
                                </div>
                            </div>
                        @endif
                        @error('thumbnail')
                            <div class="text-danger error-validation">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="mt-2 mb-0">
                        <p class="text-muted mb-0">
                            Gambar yang diupload berukuran <code>1280x760 pixel</code> atau aspect ratio <code>16:9</code>
                        </p>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </div>
        </div>
    </form>
    {{-- </div> --}}
@endsection
@push('plugin-style')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush
@push('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/srtbe9v3af040whyws0qqa3632xn7eebjiunt7fi0a7mdfc8/tinymce/5/tinymce.min.js"
        referrerpolicy="origin"></script>
    <script>
        $(window).on('load', function() {
            init();
        });

        function init() {
            $('#statusPublish').select2({
                placeholder: 'Pilih..'
            });

            var editorConfig = {
                path_absolute: "{{ env('APP_URL') }}/",
                selector: '#konten',
                document_base_url: "{{ env('APP_URL') }}/",
                relative_urls: false,
                remove_script_host: false,
                resize: false,
                height: "480px",
                plugins: [
                    "advlist autolink lists link image charmap print preview hr anchor pagebreak",
                    "searchreplace wordcount visualblocks visualchars code fullscreen",
                    "insertdatetime media nonbreaking save table directionality",
                    "emoticons template paste textpattern"
                ],
                toolbar_sticky: true,
                toolbar_mode: 'floating',
                toolbar: [
                    'undo redo | formatselect | bold italic underline fontsizeselect | alignleft aligncenter alignright | indent outdent | bullist numlist | link table image',
                ],
                file_picker_callback: function(callback, value, meta) {
                    var x = window.innerWidth || document.documentElement.clientWidth || document
                        .getElementsByTagName('body')[0].clientWidth;
                    var y = window.innerHeight || document.documentElement.clientHeight || document
                        .getElementsByTagName('body')[0].clientHeight;

                    var cmsURL = editorConfig.path_absolute + 'laravel-filemanager?editor=' + meta.fieldname;
                    if (meta.filetype == 'image') {
                        cmsURL = cmsURL + "&type=Images&_token=" + $('meta[name="csrf-token"]').attr('content');
                    } else {
                        cmsURL = cmsURL + "&type=Files&_token=" + $('meta[name="csrf-token"]').attr('content');
                    }

                    tinyMCE.activeEditor.windowManager.openUrl({
                        url: cmsURL,
                        title: 'File Manager',
                        width: x * 1,
                        height: y * 1,
                        resizable: "yes",
                        close_previous: "no",
                        onMessage: (api, message) => {
                            callback(message.content);
                        }
                    });
                }
            };
            tinymce.init(editorConfig);

        }
    </script>
@endpush
