function detail_post(id) {
    jQuery.ajax({
        url: "/get-detail-post",
        type: "get",
        dataType: "json",
        data: {
            id: id,
        },
        beforeSend: function (xhr) {
            const loader =
                '<div class="d-flex justify-content-center mt-4"><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div></div>';
            jQuery(".loader").empty();
            jQuery(".loader").append(loader);
            jQuery("#modal-instagram").show();
        },
        success: function (data) {
            var content = "";
            if (data.result.media_type == "IMAGE") {
                content += "<img src='" + data.result.media_url + "'>";
                jQuery(".loader").empty();
                jQuery("#md-ig-content").html(content);
            } else if (data.result.media_type == "CAROUSEL_ALBUM") {
                if (data.result.children.length != 0) {
                    content +=
                        "<div id='oc-images' class='owl-carousel image-carousel carousel-widget'>";
                    data.result.children.map(function (item, i) {
                        content += "<div class='oc-item'>";
                        if(item.media_type == "IMAGE"){
                            content += "<img src='" + item.media_url + "'>";
                        }else{
                            content += "<iframe src='" + item.media_url + "'></iframe>";
                        }
                        content += "</div>";
                    });
                    content += "</div>";
                    jQuery(".loader").empty();
                    jQuery("#md-ig-content").html(content);
                    jQuery("#oc-images").owlCarousel({
                        center: true,
                        items: 1,
                    });
                }
            } else {
                content += "<iframe src='" + data.result.media_url + "' allow='autoplay; fullscreen' allowfullscreen width='360' height='480'></iframe>";
                jQuery(".loader").empty();
                jQuery("#md-ig-content").html(content);
            }

            jQuery("#md-ig-caption").html(data.result.caption ?? "-");
            jQuery("#md-ig-timestamp").html(data.result.timestamp);
            jQuery("#md-ig-username").html(data.result.to_profile["username"]);
        },
        error: function (res) {
            const loader = '<div class="style-msg errormsg"><div class="sb-msg"><i class="bi-x-lg"></i><strong>Error!</strong> Gagal Memuat Data.</div></div>';
            jQuery(".loader").empty();
            jQuery(".loader").append(loader);
            jQuery("#modal-instagram").show();
        },
    });
}

function close_modal() {
    jQuery("#modal-instagram").hide();
    jQuery("#modal-instagram iframe").attr("src","");
}
