<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('instagram_feeds', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('profile_id');
            $table->string('media_id');
            $table->string('media_type');
            $table->text('media_url');
            $table->text('caption')->nullable();
            $table->text('thumbnail_url')->nullable();
            $table->string('permalink');
            $table->json('children')->nullable();
            $table->string('timestamp');
            $table->foreign('profile_id')->references('id')->on('instagram_profile')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('instagram_feeds');
    }
};
