<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('instagram_access_token', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('profile_id');
            $table->text('access_token');
            $table->string('user_id');
            $table->string('token_type');
            $table->string('expires_in');
            $table->foreign('profile_id')->references('id')->on('instagram_profile')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('instagram_access_token');
    }
};
