<?php

namespace App\View\Components\Guest;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Models\MediaSosial as PM;
use Illuminate\Support\Str;

class SosialMedia extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $data = PM::all();
        $data->map(function ($item) {
            if ($item->platform == 'whatsapp') {
                $url = Str::substr($item->url, 0, 1) == '0' ? Str::replaceStart('0', '62', $item->url) : $item->url;
                $item->url = 'https://wa.me/' . $url;
            }
            if ($item->platform == 'email') {
                $item->url = 'mailto:' . $item->url;
            }

            return $item;
        });
        return view('components.guest.sosial-media', compact('data'));
    }
}
