<?php

namespace App\View\Components\Guest;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Models\Pengumuman;

class SliderPengumuman extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $data = Pengumuman::where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->with(['to_user' => function($user){
            $user->select('id', 'name');
        }])->orderBy('tanggal_publish', 'desc')->limit(3)->get();
        return view('components.guest.slider-pengumuman', compact('data'));
    }
}
