<?php

namespace App\View\Components\Guest;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Models\Slider as PM;
use Illuminate\Support\Facades\Cache;

class Slider extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $data = Cache::remember('slider', 60*60*24, function(){
            return PM::where('is_active', 1)->get() ?? [];
        });
        return view('components.guest.slider', compact('data'));
    }
}
