<?php

namespace App\View\Components\Guest;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Models\KategoriPost as PM;

class Kategori extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $data = PM::withCount(['to_post' => function($post){
            $post->where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'));
        }])->orderBy('nama')->get();
        return view('components.guest.kategori', compact('data'));
    }
}
