<?php

namespace App\View\Components\Guest;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Support\Str;
use App\Models\InstagramFeeds;


class Instagram extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $data = InstagramFeeds::with('to_profile')
        ->orderBy('timestamp', 'desc')
        ->limit(99)
        ->simplePaginate(9,'*', 'instagram');
        return view('components.guest.instagram', compact('data'));
    }
}
