<?php

namespace App\View\Components\Guest;

use App\Models\Post;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class BeritaLainSidebar extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $data = Post::with(['to_user' => function($user){
            $user->select('id', 'name');
        }, 'to_kategori' => function($kategori){
            $kategori->select('id', 'nama');
        }])->where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->orderBy('tanggal_publish', 'desc')->limit(4)->get();
        return view('components.guest.berita-lain-sidebar', compact('data'));
    }
}
