<?php

namespace App\View\Components\Guest;

use App\Models\Post;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Request;
use Illuminate\View\Component;

class BeritaLainPost extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $slug = Request::segment(2);
        $data = Post::where('slug', '!=', $slug)->where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->with(['to_kategori' => function($kategori){
            $kategori->select('id', 'nama', 'slug');
        }, 'to_user' => function($user){
            $user->select('id', 'name');
        }])->limit(4)->get();
        return view('components.guest.berita-lain-post', compact('data'));
    }
}
