<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Validation\Rules\Password;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use App\Models\Pengaturan\InformasiWebsite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if (App::environment('production')) {
            URL::forceScheme('https');
        }
        Paginator::useBootstrapFive();
        Paginator::defaultSimpleView('vendor.pagination.simple-bootstrap-5');

        Password::defaults(function () {
            return Password::min(6);
            // ->numbers()->letters()->symbols()->mixedCase();
        });

        try {
            $config = Cache::remember('config', 60 * 60 * 24, function () {
                return InformasiWebsite::first() ?? [];
            });
        } catch (\Throwable $th) {
            $config = [];
        }

        Config::set('site.judul', $config->judul ?? '');
        Config::set('site.alamat', $config->alamat ?? '');
        Config::set('site.footer', $config->footer ?? '');
        Config::set('site.logo', $config->logo ?? '');
        Config::set('site.favicon', $config->favicon ?? '');
        Config::set('site.maps', $config->maps ?? '');
    }
}
