<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model
{
    use HasFactory, SoftDeletes;
    public $table = 'post';
    protected $guarded = ['id'];
    public $timestamps = true;

    public function to_user():BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function to_kategori():BelongsTo
    {
        return $this->belongsTo(KategoriPost::class, 'kategori_id', 'id');
    }
}
