<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Pengumuman extends Model
{
    use HasFactory, SoftDeletes;
    public $table = 'pengumuman';
    protected $guarded = ['id'];
    public $timestamps = true;

    public function to_user():BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
