<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Menu extends Model
{
    use HasFactory;
    public $table = 'menu';
    protected $guarded = ['id'];
    public $timestamps = true;

    public function to_child():HasMany
    {
        return $this->hasMany(self::class, 'parent', 'id');
    }

    public function to_parent():BelongsTo
    {
        return $this->belongsTo(self::class, 'parent', 'id');
    }

    public function to_halaman():BelongsTo
    {
        return $this->belongsTo(Halaman::class, 'halaman_id', 'id');
    }
}
