<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class KategoriPost extends Model
{
    use HasFactory, SoftDeletes;
    public $table = 'post_kategori';
    protected $guarded = ['id'];
    public $timestamps = true;

    public function to_post():HasMany
    {
        return $this->hasMany(Post::class, 'kategori_id', 'id');
    }
}
