<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Instagram;
use Illuminate\Database\Eloquent\Casts\Attribute;

class InstagramFeeds extends Model
{
    use HasFactory;
    public $table = 'instagram_feeds';
    public $timestamps = true;
    protected $guarded = ['id'];
    protected $casts = [
        'children' => 'json'
    ];

    public function to_profile():BelongsTo
    {
        return $this->belongsTo(Instagram::class, 'profile_id', 'id');
    }

    protected function timestamp(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => tanggal_indo($value),
        );
    }
}
