<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use App\Models\InstagramAccessToken;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\InstagramFeeds;

class Instagram extends Model
{
    use HasFactory;
    public $table = 'instagram_profile';
    public $timestamps = true;
    protected $guarded = ['id'];

    public function to_access_token():HasOne
    {
        return $this->hasOne(InstagramAccessToken::class, 'profile_id', 'id');
    }

    public function to_media():HasMany
    {
        return $this->hasMany(InstagramFeeds::class, 'profile_id', 'id');
    }
}
