<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Halaman extends Model
{
    use HasFactory, SoftDeletes;
    public $table = 'halaman';
    protected $guarded = ['id'];
    public $timestamps = true;

    public function to_user():BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
