<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\FotoKegiatan;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AlbumKegiatan extends Model
{
    use HasFactory;
    public $table = 'album_kegiatan';
    protected $guarded = ['id'];
    public $timestamps = true;

    public function to_foto_kegiatan():HasMany
    {
        return $this->hasMany(FotoKegiatan::class, 'album_id', 'id');
    }

    public function to_foto_kegiatan_thumbnail():HasOne
    {
        return $this->hasOne(FotoKegiatan::class, 'album_id', 'id');
    }
}
