<?php

namespace App\Livewire\Pengaturan;

use Livewire\Component;
use App\Models\Pengaturan\InformasiWebsite as PM;
use Illuminate\Support\Facades\Cache;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\DB;

class InformasiWebsite extends Component
{
    use WithFileUploads;
    public $judul, $alamat, $footer, $map, $logo, $upload, $iter = 0;
    protected $messages = [
        '*.required' => 'Tidak Boleh Kosong'
    ];

    public function mount()
    {
        $data = PM::first();
        $this->judul = $data->judul ?? null;
        $this->alamat = $data->alamat ?? null;
        $this->footer = $data->footer ?? null;
        $this->map = $data->maps ?? null;
        $this->logo = $data->logo ?? null;
    }

    public function store()
    {
        try {
            DB::beginTransaction();
            PM::updateOrcreate(['id' => 1],[
                'judul' => $this->judul,
                'alamat' => $this->alamat,
                'footer' => $this->footer,
                'maps' => $this->map
            ]);
            DB::commit();
            Cache::forget('config');
            $this->success();
        } catch (\Throwable $th) {
            DB::rollBack();
            $this->error();
        }
    }

    public function store_logo()
    {
        $this->validate(['upload' => 'required|mimes:png,jpg,svg,jpeg']);
        try {
            DB::beginTransaction();
            $file = $this->upload->store('pengaturan', 'public');
            PM::updateOrcreate(['id' => 1],[
                'logo' => $file
            ]);
            DB::commit();
            $this->success();
            Cache::forget('config');
            $this->reset_logo();
            $this->logo = $file;
        } catch (\Throwable $th) {
            DB::rollBack();
            $this->error();
        }
    }

    public function success()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Berhasil Simpan Data!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function error($msg = null)
    {
        $this->dispatch('swal:modal', [
            'type' => 'error',
            'message' => 'Operasi Gagal! ' . $msg,
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function confirm($id)
    {
        $this->dispatch('swal:confirm', [
            'type' => 'warning',
            'message' => 'Hapus Data?',
            'text' => 'Data Tidak Dapat Dikembalikan!',
            'id' => $id
        ]);
    }

    public function remove()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Data Berhasil Dihapus!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function reset_logo()
    {
        $this->reset(['upload']);
        $this->iter++;
        $this->resetValidation();
    }

    public function render()
    {
        return view('livewire.pengaturan.informasi-website');
    }
}
