<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Menu as MM;
use App\Models\Halaman;
use Livewire\Attributes\On;

class Menu extends Component
{
    public $dataLink = [];
    public $aksi, $parentNama, $parentTarget, $parentId, $jenisLink;
    public $aksiChild, $childNama, $childTarget, $childId, $jenisLinkChild;

    protected $messages = [
        '*.required' => 'Tidak Boleh Kosong'
    ];

    public function mount()
    {
        $this->dataLink = Halaman::all();
        $this->aksi = "store";
    }

    public function store()
    {
        $this->validate(['parentNama' => 'required', 'parentTarget' => 'required', 'jenisLink' => 'required']);
        try {
            MM::create(['nama' => $this->parentNama, 'jenis_link' => $this->jenisLink, 'target' => $this->parentTarget]);
            $this->success();
            $this->reset_fields();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function edit($id)
    {
        $data = MM::find($id);
        $this->parentId = $id;
        $this->parentNama = $data->nama;
        $this->jenisLink = $data->jenis_link;
        $this->parentTarget = $data->target;
        $this->aksi = "update";
        $this->dispatch('edit-parent');
    }

    public function update()
    {
        $this->validate(['parentNama' => 'required', 'parentTarget' => 'required', 'jenisLink' => 'required']);
        try {
            MM::find($this->parentId)->update(['nama' => $this->parentNama, 'jenis_link' => $this->jenisLink, 'target' => $this->parentTarget]);
            $this->success();
            $this->reset_fields();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function updatedJenisLink()
    {
        $this->reset('parentTarget');
    }

    public function updatedJenisLinkChild()
    {
        $this->reset('childTarget');
    }

    #[On('destroy')]
    public function destroy($id)
    {
        try {
            // MM::where('parent', $id)->delete();
            MM::find($id)->delete();
            $this->remove();
            $this->reset_fields();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function create_child($id)
    {
        $this->reset_child_fields();
        $this->aksiChild = "store_child";
        $this->dispatch('show-modal');
        $this->parentId = $id;
    }

    public function edit_child($id)
    {   
        $this->reset_child_fields();
        $data = MM::find($id);
        $this->aksiChild = "update_child";
        $this->childNama = $data->nama;
        $this->jenisLinkChild = $data->jenis_link;
        $this->childTarget = $data->target;
        $this->dispatch('show-modal');
        $this->childId = $id;
        $this->dispatch('edit-child');
    }

    public function store_child()
    {
        $this->validate(['childNama' => 'required', 'childTarget' => 'required', 'jenisLinkChild' => 'required']);
        try {
            MM::create(['nama' => $this->childNama, 'jenis_link' => $this->jenisLinkChild, 'target' => $this->childTarget, 'parent' => $this->parentId]);
            $this->success();
            $this->reset_child_fields();
            $this->dispatch('close-modal');
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function update_child()
    {
        $this->validate(['childNama' => 'required', 'childTarget' => 'required', 'jenisLinkChild' => 'required']);
        try {
            MM::find($this->childId)->update(['nama' => $this->childNama, 'jenis_link' => $this->jenisLinkChild, 'target' => $this->childTarget]);
            $this->success();
            $this->reset_child_fields();
            $this->dispatch('close-modal');
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    #[On('destroy-child')]
    public function destroy_child($id)
    {
        try {
            MM::find($id)->delete();
            $this->remove();
            $this->reset_child_fields();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function reset_fields()
    {
        $this->reset(['parentNama', 'parentTarget', 'parentId', 'jenisLink']);
        $this->aksi = "store";
        $this->resetValidation();
    }

    public function reset_child_fields()
    {
        $this->reset(['childNama', 'childTarget', 'childId', 'parentId', 'jenisLinkChild']);
        $this->aksiChild = "store_child";
        $this->resetValidation();
    }

    public function success()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Berhasil Simpan Data!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function error($msg = null)
    {
        $this->dispatch('swal:modal', [
            'type' => 'error',
            'message' => 'Operasi Gagal! ' . $msg,
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function confirm($id)
    {
        $this->dispatch('swal:confirm', [
            'type' => 'warning',
            'message' => 'Hapus Data?',
            'text' => 'Data Tidak Dapat Dikembalikan!',
            'id' => $id
        ]);
    }

    public function confirm_child($id)
    {
        $this->dispatch('swal:confirm-child', [
            'type' => 'warning',
            'message' => 'Hapus Data?',
            'text' => 'Data Tidak Dapat Dikembalikan!',
            'id' => $id
        ]);
    }

    public function remove()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Data Berhasil Dihapus!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function render()
    {
        $data = MM::with('to_child')->whereNull('parent')->get();
        return view('livewire.menu', compact('data'));
    }
}
