<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Link as PM;
use Livewire\Attributes\On;

class Link extends Component
{
    public $judul, $url, $aksi, $selectedId;
    protected $messages = [
        '*.required' => 'Tidak Boleh Kosong',
    ];

    public function mount()
    {
        $this->aksi = "store";
    }

    public function store()
    {
        $this->validate(['judul' => 'required', 'url' => 'required']);
        try {
            PM::create(['judul' => $this->judul, 'url' => $this->url]);
            $this->reset_fields();
            $this->success();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function edit(PM $data)
    {
        $this->judul = $data->judul;
        $this->url = $data->url;
        $this->aksi = "update";
        $this->selectedId = $data->id;
    }

    public function update()
    {
        $this->validate(['judul' => 'required']);
        try {
            PM::find($this->selectedId)->update(['judul' => $this->judul, 'url' => $this->url]);
            $this->reset_fields();
            $this->success();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    #[On('destroy')]
    public function destroy($id)
    {
        try {
            PM::find($id)->delete();
            $this->reset_fields();
            $this->success();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    #[On('set-status')]
    public function set_status($id, $status)
    {
        try {
            PM::find($id)->update(['is_active' => $status]);
            $this->reset_fields();
            $this->success();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function reset_fields()
    {
        $this->reset(['judul', 'url', 'selectedId']);
        $this->resetValidation();
        $this->aksi = "store";
    }

    public function success()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Berhasil Simpan Data!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function error($msg = null)
    {
        $this->dispatch('swal:modal', [
            'type' => 'error',
            'message' => 'Operasi Gagal! ' . $msg,
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function confirm($id)
    {
        $this->dispatch('swal:confirm', [
            'type' => 'warning',
            'message' => 'Hapus Data?',
            'text' => 'Data Tidak Dapat Dikembalikan!',
            'id' => $id
        ]);
    }

    public function remove()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Data Berhasil Dihapus!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function render()
    {
        $data = PM::all();
        return view('livewire.link', compact('data'));
    }
}
