<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\KategoriPost as PM;
use Livewire\Attributes\On;
use Illuminate\Support\Str;

class KategoriPost extends Component
{
    public $nama, $aksi, $selectedId;
    protected $messages = [
        '*.required' => 'Tidak Boleh Kosong',
        '*.unique' => 'Data Sudah Ada'
    ];

    public function mount()
    {
        $this->aksi = "store";
    }

    public function store()
    {
        $this->validate(['nama' => 'required|unique:post_kategori,nama,NULL,id,deleted_at,NULL']);
        try {
            PM::create(['nama' => $this->nama, 'slug' => Str::slug($this->nama)]);
            $this->reset_fields();
            $this->success();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function edit(PM $data)
    {
        $this->nama = $data->nama;
        $this->aksi = "update";
        $this->selectedId = $data->id;
    }

    public function update()
    {
        $this->validate(['nama' => 'required|unique:post_kategori,nama,'.$this->selectedId.',id,deleted_at,NULL']);
        try {
            PM::find($this->selectedId)->update(['nama' => $this->nama, 'slug' => Str::slug($this->nama)]);
            $this->reset_fields();
            $this->success();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    #[On('destroy')]
    public function destroy($id)
    {
        try {
            PM::find($id)->delete();
            $this->reset_fields();
            $this->success();
        } catch (\Throwable $th) {
            $this->error();
        }
    }

    public function reset_fields()
    {
        $this->reset(['nama', 'selectedId']);
        $this->resetValidation();
        $this->aksi = "store";
    }

    public function success()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Berhasil Simpan Data!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function error($msg = null)
    {
        $this->dispatch('swal:modal', [
            'type' => 'error',
            'message' => 'Operasi Gagal! ' . $msg,
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function confirm($id)
    {
        $this->dispatch('swal:confirm', [
            'type' => 'warning',
            'message' => 'Hapus Data?',
            'text' => 'Data Tidak Dapat Dikembalikan!',
            'id' => $id
        ]);
    }

    public function remove()
    {
        $this->dispatch('swal:modal', [
            'type' => 'success',
            'message' => 'Data Berhasil Dihapus!',
            'toast' => 'true',
            'position' => 'top-end'
        ]);
    }

    public function render()
    {
        $data = PM::all();
        return view('livewire.kategori-post', compact('data'));
    }
}
