<?php

namespace App\Livewire\Guest;

use Livewire\Component;
use App\Models\Post;
use Illuminate\Support\Collection;
use Livewire\WithPagination;
use Livewire\WithoutUrlPagination;

class Beranda extends Component
{
    use WithPagination, WithoutUrlPagination;
    protected $paginationTheme = 'bootstrap';

    public function render()
    {
        $data = Post::where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->with(['to_kategori' => function ($kategori) {
            $kategori->select('id', 'nama', 'slug');
        }, 'to_user' => function ($user) {
            $user->select('id', 'name');
        }])->orderBy('tanggal_publish', 'desc')->limit(30)->paginate(4);
        return view('livewire.guest.beranda', compact('data'));
    }
}
