<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class Post extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'judul' => 'required',
            'konten' => 'required',
            'tanggalPublish' => 'required',
            'gambar' => 'file|mimes:png,jpg,jpeg',
            'statusPublish' => 'required',
            'kategori' => 'required'
        ];
    }

    public function messages(): array
    {
        return [
            '*.required' => 'Tidak Boleh Kosong',
            '*.mimes' => 'File Harus Berformat :values',
            '*.file' => 'Harus File'
        ];
    }
}
