<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Post as AM;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Requests\Post;
use App\Models\KategoriPost;

class PostController extends Controller
{
    //
    public function index()
    {
        $bc = ['title' => 'Post', 'subtitle' => 'Semua Post'];
        $data = AM::orderBy('tanggal_publish', 'desc')->paginate(10);
        $sampah = AM::onlyTrashed()->count();
        return view('admin.post.index', compact('bc', 'data', 'sampah'));
    }

    public function create()
    {
        $bc = ['title' => 'Post', 'subtitle' => 'Buat Post'];
        $kategori = KategoriPost::all();
        return view('admin.post.baru', compact('bc', 'kategori'));
    }

    public function kategori()
    {
        $bc = ['title' => 'Post', 'subtitle' => 'Kategori'];
        return view('admin.post.kategori', compact('bc'));
    }

    public function store(Post $req)
    {
        try {
            DB::beginTransaction();
            $slug = $this->unique_slug(Str::slug($req->judul));
            AM::create([
                'judul' => $req->judul,
                'slug' => $slug,
                'konten' => $req->konten,
                'kategori_id' => $req->kategori,
                'route' => URL::route('post', ['slug' => $slug]),
                'tanggal_publish' => $req->tanggalPublish,
                'is_active' => $req->statusPublish,
                'thumbnail' => $req->has('thumbnail') ? $req->thumbnail->store('post', 'public') : null,
                'user_id' => Auth::id()
            ]);
            DB::commit();
            Alert::toast('Berhasil Simpan Data', 'success');
            return redirect()->route('post.semua-post');
        } catch (\Throwable $th) {
            DB::rollBack();
            Alert::toast('Gagal Simpan Data', 'error');
            return redirect()->route('post.semua-post');
        }
    }

    public function unique_slug($slug)
    {
        $isExist = true;
        $i = 1;
        do {
            if ($this->check_slug($slug) == 0) {
                $isExist = false;
            } else {
                $slug = $slug . '-' . $i;
            }
            $i++;
        } while ($isExist);
        return $slug;
    }

    public function check_slug($slug)
    {
        return AM::where('slug', $slug)->count();
    }

    public function edit($id)
    {
        $bc = ['title' => 'Post', 'subtitle' => 'Edit Post'];
        $data = AM::findOrFail($id);
        $kategori = KategoriPost::all();
        return view('admin.post.edit', compact('bc', 'data', 'kategori'));
    }

    public function update(Post $req, $id)
    {
        try {
            DB::beginTransaction();
            $slug = $this->unique_slug(Str::slug($req->judul));
            $data = [
                'judul' => $req->judul,
                'slug' => $slug,
                'konten' => $req->konten,
                'kategori_id' => $req->kategori,
                'route' => URL::route('post', ['slug' => $slug]),
                'tanggal_publish' => $req->tanggalPublish,
                'is_active' => $req->statusPublish,
            ];
            if ($req->has('thumbnail')) {
                $data['thumbnail'] = $req->thumbnail->store('post', 'public');
            }
            AM::findOrFail($id)->update($data);
            DB::commit();
            Alert::toast('Berhasil Simpan Data', 'success');
            return redirect()->route('post.semua-post');
        } catch (\Throwable $th) {
            DB::rollBack();
            Alert::toast('Gagal Simpan Data', 'error');
            return redirect()->route('post.semua-post');
        }
    }

    public function destroy($id)
    {
        try {
            AM::findOrFail($id)->delete();
            Alert::toast('Berhasil Hapus Data', 'success');
            return redirect()->route('post.semua-post');
        } catch (\Throwable $th) {
            Alert::toast('Gagal Hapus Data', 'error');
            return redirect()->route('post.semua-post');
        }
    }

    public function sampah()
    {
        $bc = ['title' => 'Post', 'subtitle' => 'Sampah'];
        $data = AM::onlyTrashed()->paginate(10);
        return view('admin.post.sampah', compact('bc', 'data'));
    }

    public function restore($id)
    {
        try {
            AM::onlyTrashed()->findOrFail($id)->restore();
            Alert::toast('Berhasil Restore Data', 'success');
            return redirect()->route('post.semua-post');
        } catch (\Throwable $th) {
            Alert::toast('Gagal Restore Data', 'error');
            return redirect()->route('post.sampah');
        }
    }

    public function force_delete($id)
    {
        try {
            $lama = AM::onlyTrashed()->findOrFail($id);
            if($lama->thumbnail){
                hapus_file($lama->thumbnail);
            }
            $lama->forceDelete();
            Alert::toast('Berhasil Hapus Data', 'success');
            return redirect()->route('post.semua-post');
        } catch (\Throwable $th) {
            Alert::toast('Gagal Hapus Data', 'error');
            return redirect()->route('post.sampah');
        }
    }
}
