<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pengumuman as AM;
use App\Http\Requests\Pengumuman;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;

class PengumumanController extends Controller
{
    //
    public function index()
    {
        $bc = ['title' => 'Pengumuman', 'subtitle' => 'Semua Pengumuman'];
        $data = AM::orderBy('id')->paginate(10);
        $sampah = AM::onlyTrashed()->count();
        return view('admin.pengumuman.index', compact('bc', 'data', 'sampah'));
    }

    public function create()
    {
        $bc = ['title' => 'Pengumuman', 'subtitle' => 'Buat Pengumuman'];
        return view('admin.pengumuman.baru', compact('bc'));
    }

    public function store(Pengumuman $req)
    {
        try {
            DB::beginTransaction();
            $slug = $this->unique_slug(Str::slug($req->judul));
            AM::create([
                'judul' => $req->judul,
                'slug' => $slug,
                'konten' => $req->konten,
                'tanggal_publish' => $req->tanggalPublish,
                'route' => URL::route('pengumuman', ['slug' => $slug]),
                'is_active' => $req->statusPublish,
                'thumbnail' => $req->has('thumbnail') ? $req->thumbnail->store('pengumuman', 'public') : null,
                'user_id' => Auth::id()
            ]);
            DB::commit();
            Alert::toast('Berhasil Simpan Data', 'success');
            return redirect()->route('pengumuman.semua-pengumuman');
        } catch (\Throwable $th) {
            DB::rollBack();
            Alert::toast('Gagal Simpan Data', 'error');
            return redirect()->route('pengumuman.semua-pengumuman');
        }
    }

    public function unique_slug($slug)
    {
        $isExist = true;
        $i = 1;
        do {
            if ($this->check_slug($slug) == 0) {
                $isExist = false;
            } else {
                $slug = $slug . '-' . $i;
            }
            $i++;
        } while ($isExist);
        return $slug;
    }

    public function check_slug($slug)
    {
        return AM::where('slug', $slug)->count();
    }

    public function edit($id)
    {
        $bc = ['title' => 'Pengumuman', 'subtitle' => 'Edit Pengumuman'];
        $data = AM::findOrFail($id);
        return view('admin.pengumuman.edit', compact('bc', 'data'));
    }

    public function update(Pengumuman $req, $id)
    {
        try {
            DB::beginTransaction();
            $slug = $this->unique_slug(Str::slug($req->judul));
            $data = [
                'judul' => $req->judul,
                'slug' => $slug,
                'konten' => $req->konten,
                'tanggal_publish' => $req->tanggalPublish,
                'route' => URL::route('pengumuman', ['slug' => $slug]),
                'is_active' => $req->statusPublish,
            ];
            if ($req->has('thumbnail')) {
                $data['thumbnail'] = $req->thumbnail->store('pengumuman', 'public');
            }
            AM::findOrFail($id)->update($data);
            DB::commit();
            Alert::toast('Berhasil Simpan Data', 'success');
            return redirect()->route('pengumuman.semua-pengumuman');
        } catch (\Throwable $th) {
            DB::rollBack();
            Alert::toast('Gagal Simpan Data', 'error');
            return redirect()->route('pengumuman.semua-pengumuman');
        }
    }

    public function destroy($id)
    {
        try {
            AM::findOrFail($id)->delete();
            Alert::toast('Berhasil Hapus Data', 'success');
            return redirect()->route('pengumuman.semua-pengumuman');
        } catch (\Throwable $th) {
            Alert::toast('Gagal Hapus Data', 'error');
            return redirect()->route('pengumuman.semua-pengumuman');
        }
    }

    public function sampah()
    {
        $bc = ['title' => 'Pengumuman', 'subtitle' => 'Sampah'];
        $data = AM::onlyTrashed()->paginate(10);
        return view('admin.pengumuman.sampah', compact('bc', 'data'));
    }

    public function restore($id)
    {
        try {
            AM::onlyTrashed()->findOrFail($id)->restore();
            Alert::toast('Berhasil Restore Data', 'success');
            return redirect()->route('pengumuman.semua-pengumuman');
        } catch (\Throwable $th) {
            Alert::toast('Gagal Restore Data', 'error');
            return redirect()->route('pengumuman.sampah');
        }
    }

    public function force_delete($id)
    {
        try {
            $lama = AM::onlyTrashed()->findOrFail($id);
            if($lama->thumbnail){
                hapus_file($lama->thumbnail);
            }
            $lama->forceDelete();
            Alert::toast('Berhasil Hapus Data', 'success');
            return redirect()->route('pengumuman.semua-pengumuman');
        } catch (\Throwable $th) {
            Alert::toast('Gagal Hapus Data', 'error');
            return redirect()->route('pengumuman.sampah');
        }
    }
}
